/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshotWrapper;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class TtlAwareSerializer<T, S extends TypeSerializer<T>>
extends TypeSerializer<T> {
    private final boolean isTtlEnabled;
    private final S typeSerializer;

    public TtlAwareSerializer(S typeSerializer) {
        Preconditions.checkArgument((!(typeSerializer instanceof TtlAwareSerializer) ? 1 : 0) != 0, (Object)(String.valueOf(typeSerializer) + " is already instance of TtlAwareSerializer, should not be wrapped repeatedly."));
        this.typeSerializer = typeSerializer;
        this.isTtlEnabled = TtlStateFactory.TtlSerializer.isTtlStateSerializer(typeSerializer);
    }

    public TtlAwareSerializer(S typeSerializer, boolean isTtlEnabled) {
        Preconditions.checkArgument((!(typeSerializer instanceof TtlAwareSerializer) ? 1 : 0) != 0, (Object)(String.valueOf(typeSerializer) + " is already instance of TtlAwareSerializer, should not be wrapped repeatedly."));
        this.typeSerializer = typeSerializer;
        this.isTtlEnabled = isTtlEnabled;
    }

    public boolean isImmutableType() {
        return this.typeSerializer.isImmutableType();
    }

    public TypeSerializer<T> duplicate() {
        return new TtlAwareSerializer<T, TypeSerializer>(this.typeSerializer.duplicate(), this.isTtlEnabled);
    }

    public T createInstance() {
        return (T)this.typeSerializer.createInstance();
    }

    public T copy(T from) {
        return (T)this.typeSerializer.copy(from);
    }

    public T copy(T from, T reuse) {
        return (T)this.typeSerializer.copy(from, reuse);
    }

    public int getLength() {
        return this.typeSerializer.getLength();
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        this.typeSerializer.serialize(record, target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return (T)this.typeSerializer.deserialize(source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.typeSerializer.deserialize(reuse, source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TtlAwareSerializer that = (TtlAwareSerializer)((Object)o);
        return this.isTtlEnabled == that.isTtlEnabled && Objects.equals(this.typeSerializer, that.typeSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.isTtlEnabled, this.typeSerializer);
    }

    public void migrateValueFromPriorSerializer(TtlAwareSerializer<T, ?> priorTtlAwareSerializer, SupplierWithException<T, IOException> inputSupplier, DataOutputView target, TtlTimeProvider ttlTimeProvider) throws IOException {
        Object outputRecord = this.isTtlEnabled() ? (priorTtlAwareSerializer.isTtlEnabled ? inputSupplier.get() : new TtlValue<Object>(inputSupplier.get(), ttlTimeProvider.currentTimestamp())) : (priorTtlAwareSerializer.isTtlEnabled ? ((TtlValue)inputSupplier.get()).getUserValue() : inputSupplier.get());
        this.serialize(outputRecord, target);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.typeSerializer.copy(source, target);
    }

    public boolean isTtlEnabled() {
        return this.isTtlEnabled;
    }

    public S getOriginalTypeSerializer() {
        return this.typeSerializer;
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new TtlAwareSerializerSnapshotWrapper(this.typeSerializer.snapshotConfiguration()).getTtlAwareSerializerSnapshot();
    }

    public static boolean isSerializerTtlEnabled(TypeSerializer<?> typeSerializer) {
        return TtlAwareSerializer.wrapTtlAwareSerializer(typeSerializer).isTtlEnabled();
    }

    public static boolean needTtlStateMigration(TypeSerializer<?> previousSerializer, TypeSerializer<?> newSerializer) {
        return TtlAwareSerializer.isSerializerTtlEnabled(previousSerializer) != TtlAwareSerializer.isSerializerTtlEnabled(newSerializer);
    }

    public static TtlAwareSerializer<?, ?> wrapTtlAwareSerializer(TypeSerializer<?> typeSerializer) {
        if (typeSerializer instanceof TtlAwareSerializer) {
            return (TtlAwareSerializer)typeSerializer;
        }
        if (typeSerializer instanceof ListSerializer) {
            return new TtlAwareListSerializer((ListSerializer)typeSerializer);
        }
        if (typeSerializer instanceof MapSerializer) {
            return new TtlAwareMapSerializer((MapSerializer)typeSerializer);
        }
        return new TtlAwareSerializer(typeSerializer);
    }

    public static class TtlAwareMapSerializer<K, V>
    extends TtlAwareSerializer<Map<K, V>, MapSerializer<K, V>> {
        public TtlAwareMapSerializer(MapSerializer<K, V> typeSerializer) {
            super(typeSerializer);
        }

        public TtlAwareSerializer<K, TypeSerializer<K>> getKeySerializer() {
            return TtlAwareSerializer.wrapTtlAwareSerializer(((MapSerializer)this.getOriginalTypeSerializer()).getKeySerializer());
        }

        public TtlAwareSerializer<V, TypeSerializer<V>> getValueSerializer() {
            return TtlAwareSerializer.wrapTtlAwareSerializer(((MapSerializer)this.getOriginalTypeSerializer()).getValueSerializer());
        }
    }

    public static class TtlAwareListSerializer<T>
    extends TtlAwareSerializer<List<T>, ListSerializer<T>> {
        public TtlAwareListSerializer(ListSerializer<T> typeSerializer) {
            super(typeSerializer);
        }

        public TtlAwareSerializer<T, TypeSerializer<T>> getElementSerializer() {
            return TtlAwareSerializer.wrapTtlAwareSerializer(((ListSerializer)this.getOriginalTypeSerializer()).getElementSerializer());
        }
    }
}

