/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.DeterminismEnvelope;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.apache.flink.runtime.util.ClusterUncaughtExceptionHandler;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterEntrypointUtils {
    protected static final Logger LOG = LoggerFactory.getLogger(ClusterEntrypointUtils.class);

    private ClusterEntrypointUtils() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }

    public static <T> T parseParametersOrExit(String[] args, ParserResultFactory<T> parserResultFactory, Class<?> mainClass) {
        CommandLineParser<T> commandLineParser = new CommandLineParser<T>(parserResultFactory);
        try {
            return commandLineParser.parse(args);
        }
        catch (Exception e) {
            LOG.error("Could not parse command line arguments {}.", (Object)args, (Object)e);
            commandLineParser.printHelp(mainClass.getSimpleName());
            System.exit(1);
            return null;
        }
    }

    public static Optional<File> tryFindUserLibDirectory() {
        File flinkHomeDirectory = ClusterEntrypointUtils.deriveFlinkHomeDirectoryFromLibDirectory();
        File usrLibDirectory = new File(flinkHomeDirectory, "usrlib");
        if (!usrLibDirectory.isDirectory()) {
            return Optional.empty();
        }
        return Optional.of(usrLibDirectory);
    }

    @Nullable
    private static File deriveFlinkHomeDirectoryFromLibDirectory() {
        String libDirectory = System.getenv().get("FLINK_LIB_DIR");
        if (libDirectory == null) {
            return null;
        }
        return new File(libDirectory).getParentFile();
    }

    public static int getPoolSize(Configuration config) {
        int poolSize = (Integer)config.get(ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE, (Object)(4 * Hardware.getNumberCPUCores()));
        Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (String)"Illegal pool size (%s) of io-executor, please re-configure '%s'.", (Object[])new Object[]{poolSize, ClusterOptions.CLUSTER_IO_EXECUTOR_POOL_SIZE.key()});
        return poolSize;
    }

    public static void configureUncaughtExceptionHandler(Configuration config) {
        Thread.setDefaultUncaughtExceptionHandler(new ClusterUncaughtExceptionHandler((ClusterOptions.UncaughtExceptionHandleMode)config.get(ClusterOptions.UNCAUGHT_EXCEPTION_HANDLING)));
    }

    public static DeterminismEnvelope<WorkingDirectory> createTaskManagerWorkingDirectory(Configuration configuration, DeterminismEnvelope<ResourceID> envelopedResourceId) throws IOException {
        return envelopedResourceId.map(resourceId -> WorkingDirectory.create(ClusterEntrypointUtils.generateTaskManagerWorkingDirectoryFile(configuration, resourceId)));
    }

    @VisibleForTesting
    public static File generateTaskManagerWorkingDirectoryFile(Configuration configuration, ResourceID resourceId) {
        return ClusterEntrypointUtils.generateWorkingDirectoryFile(configuration, Optional.of(ClusterOptions.TASK_MANAGER_PROCESS_WORKING_DIR_BASE), "tm_" + String.valueOf(resourceId));
    }

    @VisibleForTesting
    public static File generateJobManagerWorkingDirectoryFile(Configuration configuration, ResourceID resourceId) {
        return ClusterEntrypointUtils.generateWorkingDirectoryFile(configuration, Optional.of(ClusterOptions.JOB_MANAGER_PROCESS_WORKING_DIR_BASE), "jm_" + String.valueOf(resourceId));
    }

    public static File generateWorkingDirectoryFile(Configuration configuration, Optional<ConfigOption<String>> workingDirOption, String workingDirectoryName) {
        Optional<File> optionalWorkingDirectory = workingDirOption.flatMap(arg_0 -> ((Configuration)configuration).getOptional(arg_0));
        File workingDirectoryBase = optionalWorkingDirectory.map(File::new).orElseGet(() -> {
            File tempDirectory = ConfigurationUtils.getRandomTempDirectory((Configuration)configuration);
            LOG.debug("Picked {} randomly from the configured temporary directories to be used as working directory base.", (Object)tempDirectory);
            return tempDirectory;
        });
        return new File(workingDirectoryBase, workingDirectoryName);
    }

    public static DeterminismEnvelope<WorkingDirectory> createJobManagerWorkingDirectory(Configuration configuration, DeterminismEnvelope<ResourceID> envelopedResourceId) throws IOException {
        return envelopedResourceId.map(resourceId -> WorkingDirectory.create(ClusterEntrypointUtils.generateJobManagerWorkingDirectoryFile(configuration, resourceId)));
    }
}

