/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class KeyedProcessOperator<K, IN, OUT>
extends AbstractUdfStreamOperator<OUT, KeyedProcessFunction<K, IN, OUT>>
implements OneInputStreamOperator<IN, OUT>,
Triggerable<K, VoidNamespace> {
    private static final long serialVersionUID = 1L;
    private transient TimestampedCollector<OUT> collector;
    private transient ContextImpl context;
    private transient OnTimerContextImpl onTimerContext;

    public KeyedProcessOperator(KeyedProcessFunction<K, IN, OUT> function) {
        super(function);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        InternalTimerService<VoidNamespace> internalTimerService = this.getInternalTimerService("user-timers", VoidNamespaceSerializer.INSTANCE, this);
        SimpleTimerService timerService = new SimpleTimerService(internalTimerService);
        this.context = new ContextImpl((KeyedProcessFunction)this.userFunction, timerService);
        this.onTimerContext = new OnTimerContextImpl((KeyedProcessFunction)this.userFunction, timerService);
    }

    @Override
    public void onEventTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.setAbsoluteTimestamp(timer.getTimestamp());
        this.invokeUserFunction(TimeDomain.EVENT_TIME, timer);
    }

    @Override
    public void processWatermark(WatermarkEvent watermark) throws Exception {
        this.output.emitWatermark(watermark);
    }

    @Override
    public void onProcessingTime(InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.collector.eraseTimestamp();
        this.invokeUserFunction(TimeDomain.PROCESSING_TIME, timer);
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        this.collector.setTimestamp(element);
        this.context.element = element;
        ((KeyedProcessFunction)this.userFunction).processElement(element.getValue(), this.context, this.collector);
        this.context.element = null;
    }

    private void invokeUserFunction(TimeDomain timeDomain, InternalTimer<K, VoidNamespace> timer) throws Exception {
        this.onTimerContext.timeDomain = timeDomain;
        this.onTimerContext.timer = timer;
        ((KeyedProcessFunction)this.userFunction).onTimer(timer.getTimestamp(), this.onTimerContext, this.collector);
        this.onTimerContext.timeDomain = null;
        this.onTimerContext.timer = null;
    }

    private class OnTimerContextImpl
    extends KeyedProcessFunction.OnTimerContext {
        private final TimerService timerService;
        private TimeDomain timeDomain;
        private InternalTimer<K, VoidNamespace> timer;

        OnTimerContextImpl(KeyedProcessFunction<K, IN, OUT> function, TimerService timerService) {
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.timer != null ? 1 : 0) != 0);
            return this.timer.getTimestamp();
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            KeyedProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.timer.getTimestamp()));
        }

        @Override
        public TimeDomain timeDomain() {
            Preconditions.checkState((this.timeDomain != null ? 1 : 0) != 0);
            return this.timeDomain;
        }

        @Override
        public K getCurrentKey() {
            return this.timer.getKey();
        }
    }

    private class ContextImpl
    extends KeyedProcessFunction.Context {
        private final TimerService timerService;
        private StreamRecord<IN> element;

        ContextImpl(KeyedProcessFunction<K, IN, OUT> function, TimerService timerService) {
            this.timerService = (TimerService)Preconditions.checkNotNull((Object)timerService);
        }

        @Override
        public Long timestamp() {
            Preconditions.checkState((this.element != null ? 1 : 0) != 0);
            if (this.element.hasTimestamp()) {
                return this.element.getTimestamp();
            }
            return null;
        }

        @Override
        public TimerService timerService() {
            return this.timerService;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            if (outputTag == null) {
                throw new IllegalArgumentException("OutputTag must not be null.");
            }
            KeyedProcessOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.element.getTimestamp()));
        }

        @Override
        public K getCurrentKey() {
            return KeyedProcessOperator.this.getCurrentKey();
        }
    }
}

