/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source.legacy;

import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.streaming.api.functions.source.legacy.RichParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.legacy.SourceFunction;
import org.apache.flink.util.SplittableIterator;

@Internal
public class FromSplittableIteratorFunction<T>
extends RichParallelSourceFunction<T> {
    private static final long serialVersionUID = 1L;
    private SplittableIterator<T> fullIterator;
    private transient Iterator<T> iterator;
    private volatile boolean isRunning = true;

    public FromSplittableIteratorFunction(SplittableIterator<T> iterator) {
        this.fullIterator = iterator;
    }

    public void open(OpenContext openContext) throws Exception {
        int numberOfSubTasks = this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks();
        int indexofThisSubTask = this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask();
        this.iterator = this.fullIterator.split(numberOfSubTasks)[indexofThisSubTask];
        this.isRunning = true;
    }

    @Override
    public void run(SourceFunction.SourceContext<T> ctx) throws Exception {
        while (this.isRunning && this.iterator.hasNext()) {
            ctx.collect(this.iterator.next());
        }
    }

    @Override
    public void cancel() {
        this.isRunning = false;
    }
}

