/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.cluster.AbstractJobManagerFileHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.LogFileNamePathParameter;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.cluster.FileMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobManagerCustomLogHandler
extends AbstractJobManagerFileHandler<FileMessageParameters> {
    private File logDir;

    public JobManagerCustomLogHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, UntypedResponseMessageHeaders<EmptyRequestBody, FileMessageParameters> messageHeaders, @Nullable File logDir) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.logDir = logDir;
    }

    @Override
    protected File getFile(HandlerRequest<EmptyRequestBody> handlerRequest) {
        if (this.logDir == null) {
            return null;
        }
        String filename = new File((String)handlerRequest.getPathParameter(LogFileNamePathParameter.class)).getName();
        return new File(this.logDir, filename);
    }
}

