/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Objects;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.checkpoint.SnapshotType;

public class SavepointType
implements SnapshotType {
    private final String name;
    private final PostCheckpointAction postCheckpointAction;
    private final SavepointFormatType formatType;

    private SavepointType(String name, PostCheckpointAction postCheckpointAction, SavepointFormatType formatType) {
        this.postCheckpointAction = postCheckpointAction;
        this.name = name;
        this.formatType = formatType;
    }

    public static SavepointType savepoint(SavepointFormatType formatType) {
        return new SavepointType("Savepoint", PostCheckpointAction.NONE, formatType);
    }

    public static SavepointType terminate(SavepointFormatType formatType) {
        return new SavepointType("Terminate Savepoint", PostCheckpointAction.TERMINATE, formatType);
    }

    public static SavepointType suspend(SavepointFormatType formatType) {
        return new SavepointType("Suspend Savepoint", PostCheckpointAction.SUSPEND, formatType);
    }

    @Override
    public boolean isSavepoint() {
        return true;
    }

    public boolean isSynchronous() {
        return this.postCheckpointAction != PostCheckpointAction.NONE;
    }

    public PostCheckpointAction getPostCheckpointAction() {
        return this.postCheckpointAction;
    }

    public boolean shouldAdvanceToEndOfTime() {
        return this.shouldDrain();
    }

    public boolean shouldDrain() {
        return this.getPostCheckpointAction() == PostCheckpointAction.TERMINATE;
    }

    public boolean shouldIgnoreEndOfInput() {
        return this.getPostCheckpointAction() == PostCheckpointAction.SUSPEND;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }

    @Override
    public SnapshotType.SharingFilesStrategy getSharingFilesStrategy() {
        return SnapshotType.SharingFilesStrategy.NO_SHARING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SavepointType that = (SavepointType)o;
        return this.name.equals(that.name) && this.postCheckpointAction == that.postCheckpointAction && this.formatType == that.formatType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.postCheckpointAction, this.formatType});
    }

    public String toString() {
        return "SavepointType{name='" + this.name + "', postCheckpointAction=" + this.postCheckpointAction + ", formatType=" + this.formatType + "}";
    }

    public static enum PostCheckpointAction {
        NONE,
        SUSPEND,
        TERMINATE;

    }
}

