/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.util.function.ThrowingRunnable;

public class CallbackRunnerWrapper {
    private final MailboxExecutor mailboxExecutor;
    private final AtomicInteger currentCallbacks = new AtomicInteger(0);
    private final Runnable newMailNotify;

    CallbackRunnerWrapper(MailboxExecutor mailboxExecutor, Runnable newMailNotify) {
        this.mailboxExecutor = mailboxExecutor;
        this.newMailNotify = newMailNotify;
    }

    public void submit(ThrowingRunnable<? extends Exception> task) {
        this.mailboxExecutor.execute(() -> {
            this.currentCallbacks.decrementAndGet();
            task.run();
        }, "Callback of state request");
        if (this.currentCallbacks.getAndIncrement() == 0) {
            this.notifyNewMail();
        }
    }

    private void notifyNewMail() {
        if (this.newMailNotify != null) {
            this.newMailNotify.run();
        }
    }

    public boolean isHasMail() {
        return this.currentCallbacks.get() > 0;
    }
}

