/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.runtime.util.config.memory.ManagedMemoryUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class ManagedMemoryUtilsTest {
    private static final double DELTA = 1.0E-6;
    private static final int PYTHON_WEIGHT = 222;
    private static final int OPERATOR_WEIGHT = 333;
    private static final int STATE_BACKEND_WEIGHT = 444;
    private static final int TOTAL_WEIGHT = 999;
    private static final UnmodifiableConfiguration CONFIG_WITH_ALL_USE_CASES = new UnmodifiableConfiguration(new Configuration(){
        {
            this.set(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS, new HashMap<String, String>(){
                {
                    this.put("PYTHON", String.valueOf(222));
                    this.put("OPERATOR", String.valueOf(333));
                    this.put("STATE_BACKEND", String.valueOf(444));
                }
            });
        }
    });
    private static final UnmodifiableConfiguration CONFIG_WITH_LEGACY_USE_CASES = new UnmodifiableConfiguration(new Configuration(){
        {
            this.set(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS, new HashMap<String, String>(){
                {
                    this.put("PYTHON", String.valueOf(222));
                }
            });
        }
    });

    ManagedMemoryUtilsTest() {
    }

    @Test
    void testGetWeightsFromConfig() {
        HashMap<ManagedMemoryUseCase, Integer> expectedWeights = new HashMap<ManagedMemoryUseCase, Integer>(){
            {
                this.put(ManagedMemoryUseCase.OPERATOR, 333);
                this.put(ManagedMemoryUseCase.STATE_BACKEND, 444);
                this.put(ManagedMemoryUseCase.PYTHON, 222);
            }
        };
        Map configuredWeights = ManagedMemoryUtils.getManagedMemoryUseCaseWeightsFromConfig((Configuration)CONFIG_WITH_ALL_USE_CASES);
        Assertions.assertThat((Map)configuredWeights).isEqualTo((Object)expectedWeights);
    }

    @Test
    void testGetWeightsFromConfigFailNegativeWeight() {
        Configuration config = new Configuration(){
            {
                this.set(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS, Collections.singletonMap("OPERATOR", "-123"));
            }
        };
        Assertions.assertThatThrownBy(() -> ManagedMemoryUtils.getManagedMemoryUseCaseWeightsFromConfig((Configuration)config)).isInstanceOf(IllegalConfigurationException.class);
    }

    @Test
    void testConvertToFractionOfSlot() {
        ManagedMemoryUseCase useCase = ManagedMemoryUseCase.OPERATOR;
        double fractionOfUseCase = 0.3;
        double fractionOfSlot = ManagedMemoryUtils.convertToFractionOfSlot((ManagedMemoryUseCase)useCase, (double)0.3, (Set)new HashSet<ManagedMemoryUseCase>(){
            {
                this.add(ManagedMemoryUseCase.OPERATOR);
                this.add(ManagedMemoryUseCase.STATE_BACKEND);
                this.add(ManagedMemoryUseCase.PYTHON);
            }
        }, (Configuration)new Configuration(), (Configuration)CONFIG_WITH_ALL_USE_CASES, Optional.of(true), (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertThat((double)fractionOfSlot).isCloseTo(0.09999999999999999, Offset.offset((Number)1.0E-6));
    }

    @Test
    void testConvertToFractionOfSlotWeightNotConfigured() {
        ManagedMemoryUseCase useCase = ManagedMemoryUseCase.OPERATOR;
        double fractionOfUseCase = 0.3;
        Configuration config = new Configuration(){
            {
                this.set(TaskManagerOptions.MANAGED_MEMORY_CONSUMER_WEIGHTS, Collections.emptyMap());
            }
        };
        double fractionOfSlot = ManagedMemoryUtils.convertToFractionOfSlot((ManagedMemoryUseCase)useCase, (double)0.3, (Set)new HashSet<ManagedMemoryUseCase>(){
            {
                this.add(ManagedMemoryUseCase.OPERATOR);
                this.add(ManagedMemoryUseCase.STATE_BACKEND);
                this.add(ManagedMemoryUseCase.PYTHON);
            }
        }, (Configuration)new Configuration(), (Configuration)config, Optional.of(true), (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertThat((double)fractionOfSlot).isCloseTo(0.0, Offset.offset((Number)1.0E-6));
    }

    @Test
    void testConvertToFractionOfSlotStateBackendUseManagedMemory() {
        this.testConvertToFractionOfSlotGivenWhetherStateBackendUsesManagedMemory(true, 0.3333333333333333, 0.4444444444444444, 0.2222222222222222);
    }

    @Test
    void testConvertToFractionOfSlotStateBackendNotUserManagedMemory() {
        int totalWeight = 555;
        this.testConvertToFractionOfSlotGivenWhetherStateBackendUsesManagedMemory(false, 0.6, 0.0, 0.4);
    }

    private void testConvertToFractionOfSlotGivenWhetherStateBackendUsesManagedMemory(boolean stateBackendUsesManagedMemory, double expectedOperatorFractionOfSlot, double expectedStateFractionOfSlot, double expectedPythonFractionOfSlot) {
        HashSet<ManagedMemoryUseCase> allUseCases = new HashSet<ManagedMemoryUseCase>(){
            {
                this.add(ManagedMemoryUseCase.OPERATOR);
                this.add(ManagedMemoryUseCase.STATE_BACKEND);
                this.add(ManagedMemoryUseCase.PYTHON);
            }
        };
        double opFractionOfSlot = ManagedMemoryUtils.convertToFractionOfSlot((ManagedMemoryUseCase)ManagedMemoryUseCase.OPERATOR, (double)1.0, (Set)allUseCases, (Configuration)new Configuration(), (Configuration)CONFIG_WITH_ALL_USE_CASES, Optional.of(stateBackendUsesManagedMemory), (ClassLoader)ClassLoader.getSystemClassLoader());
        double stateFractionOfSlot = ManagedMemoryUtils.convertToFractionOfSlot((ManagedMemoryUseCase)ManagedMemoryUseCase.STATE_BACKEND, (double)1.0, (Set)allUseCases, (Configuration)new Configuration(), (Configuration)CONFIG_WITH_ALL_USE_CASES, Optional.of(stateBackendUsesManagedMemory), (ClassLoader)ClassLoader.getSystemClassLoader());
        double pythonFractionOfSlot = ManagedMemoryUtils.convertToFractionOfSlot((ManagedMemoryUseCase)ManagedMemoryUseCase.PYTHON, (double)1.0, (Set)allUseCases, (Configuration)new Configuration(), (Configuration)CONFIG_WITH_ALL_USE_CASES, Optional.of(stateBackendUsesManagedMemory), (ClassLoader)ClassLoader.getSystemClassLoader());
        Assertions.assertThat((double)opFractionOfSlot).isCloseTo(expectedOperatorFractionOfSlot, Offset.offset((Number)1.0E-6));
        Assertions.assertThat((double)stateFractionOfSlot).isCloseTo(expectedStateFractionOfSlot, Offset.offset((Number)1.0E-6));
        Assertions.assertThat((double)pythonFractionOfSlot).isCloseTo(expectedPythonFractionOfSlot, Offset.offset((Number)1.0E-6));
    }

    @Test
    void testUseCaseWeightsConfiguredWithConsistentValue() {
        HashMap<ManagedMemoryUseCase, Integer> existingWeights = new HashMap<ManagedMemoryUseCase, Integer>(){
            {
                this.put(ManagedMemoryUseCase.OPERATOR, 123);
            }
        };
        HashMap<ManagedMemoryUseCase, Integer> newWeights = new HashMap<ManagedMemoryUseCase, Integer>(){
            {
                this.put(ManagedMemoryUseCase.OPERATOR, 123);
                this.put(ManagedMemoryUseCase.STATE_BACKEND, 456);
            }
        };
        ManagedMemoryUtils.validateUseCaseWeightsNotConflict((Map)existingWeights, (Map)newWeights);
    }

    @Test
    void testUseCaseWeightsConfiguredWithConflictValue() {
        HashMap<ManagedMemoryUseCase, Integer> existingWeights = new HashMap<ManagedMemoryUseCase, Integer>(){
            {
                this.put(ManagedMemoryUseCase.OPERATOR, 123);
            }
        };
        HashMap<ManagedMemoryUseCase, Integer> newWeights = new HashMap<ManagedMemoryUseCase, Integer>(){
            {
                this.put(ManagedMemoryUseCase.OPERATOR, 456);
            }
        };
        Assertions.assertThatThrownBy(() -> ManagedMemoryUtils.validateUseCaseWeightsNotConflict((Map)existingWeights, (Map)newWeights)).isInstanceOf(IllegalStateException.class);
    }
}

