/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializerSnapshot;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshot;
import org.apache.flink.runtime.state.ttl.TtlStateFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TtlAwareSerializerTest {
    TtlAwareSerializerTest() {
    }

    @Test
    void testSerializerTtlEnabled() {
        IntSerializer intSerializer = IntSerializer.INSTANCE;
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)intSerializer);
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intSerializer);
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)intSerializer)).isFalse();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)listSerializer)).isFalse();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)mapSerializer)).isFalse();
        TtlStateFactory.TtlSerializer intTtlSerializer = new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)intSerializer);
        ListSerializer listTtlSerializer = new ListSerializer((TypeSerializer)intTtlSerializer);
        MapSerializer mapTtlSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intTtlSerializer);
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)intTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)listTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.isSerializerTtlEnabled((TypeSerializer)mapTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.needTtlStateMigration((TypeSerializer)intSerializer, (TypeSerializer)intTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.needTtlStateMigration((TypeSerializer)listSerializer, (TypeSerializer)listTtlSerializer)).isTrue();
        Assertions.assertThat((boolean)TtlAwareSerializer.needTtlStateMigration((TypeSerializer)mapSerializer, (TypeSerializer)mapTtlSerializer)).isTrue();
    }

    @Test
    void testWrapTypeSerializer() {
        IntSerializer intSerializer = IntSerializer.INSTANCE;
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)intSerializer);
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)intSerializer, (TypeSerializer)intSerializer);
        TtlAwareSerializer intTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)intSerializer);
        TtlAwareSerializer listTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)listSerializer);
        TtlAwareSerializer mapTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)mapSerializer);
        Assertions.assertThat((boolean)intTtlAwareSerializer.isTtlEnabled()).isFalse();
        Assertions.assertThat((Object)listTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.TtlAwareListSerializer.class);
        Assertions.assertThat((boolean)listTtlAwareSerializer.isTtlEnabled()).isFalse();
        Assertions.assertThat((Object)mapTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.TtlAwareMapSerializer.class);
        Assertions.assertThat((boolean)mapTtlAwareSerializer.isTtlEnabled()).isFalse();
    }

    @Test
    void testWrapTtlSerializer() {
        TtlStateFactory.TtlSerializer intTtlSerializer = new TtlStateFactory.TtlSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE);
        ListSerializer listTtlSerializer = new ListSerializer((TypeSerializer)intTtlSerializer);
        MapSerializer mapTtlSerializer = new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)intTtlSerializer);
        TtlAwareSerializer intTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)intTtlSerializer);
        TtlAwareSerializer listTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)listTtlSerializer);
        TtlAwareSerializer mapTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)mapTtlSerializer);
        Assertions.assertThat((boolean)intTtlAwareSerializer.isTtlEnabled()).isTrue();
        Assertions.assertThat((Object)listTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.TtlAwareListSerializer.class);
        Assertions.assertThat((boolean)listTtlAwareSerializer.isTtlEnabled()).isTrue();
        Assertions.assertThat((Object)mapTtlAwareSerializer).isInstanceOf(TtlAwareSerializer.TtlAwareMapSerializer.class);
        Assertions.assertThat((boolean)mapTtlAwareSerializer.isTtlEnabled()).isTrue();
    }

    @Test
    void testSnapshotConfiguration() {
        TtlAwareSerializer intTtlAwareSerializer = TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)IntSerializer.INSTANCE);
        TtlAwareSerializer.TtlAwareListSerializer listTtlAwareSerializer = (TtlAwareSerializer.TtlAwareListSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)new ListSerializer((TypeSerializer)IntSerializer.INSTANCE));
        TtlAwareSerializer.TtlAwareMapSerializer mapTtlAwareSerializer = (TtlAwareSerializer.TtlAwareMapSerializer)TtlAwareSerializer.wrapTtlAwareSerializer((TypeSerializer)new MapSerializer((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE));
        Assertions.assertThat((Object)intTtlAwareSerializer.snapshotConfiguration()).isInstanceOf(TtlAwareSerializerSnapshot.class);
        Assertions.assertThat((Object)((TtlAwareSerializerSnapshot)intTtlAwareSerializer.snapshotConfiguration()).getOrinalTypeSerializerSnapshot()).isInstanceOf(IntSerializer.IntSerializerSnapshot.class);
        Assertions.assertThat((Object)listTtlAwareSerializer.snapshotConfiguration()).isInstanceOf(ListSerializerSnapshot.class);
        Assertions.assertThat((Object)((ListSerializerSnapshot)listTtlAwareSerializer.snapshotConfiguration()).getElementSerializerSnapshot()).isInstanceOf(TtlAwareSerializerSnapshot.class);
        Assertions.assertThat((Object)mapTtlAwareSerializer.snapshotConfiguration()).isInstanceOf(MapSerializerSnapshot.class);
        Assertions.assertThat((Object)((MapSerializerSnapshot)mapTtlAwareSerializer.snapshotConfiguration()).getValueSerializerSnapshot()).isInstanceOf(TtlAwareSerializerSnapshot.class);
    }
}

