/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshot;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializerSnapshotWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TtlAwareSerializerSnapshotWrapperTest {
    @Test
    public void testValueStateTtlAwareSerializerSnapshot() {
        TypeSerializerSnapshot intSerializerSnapshot = IntSerializer.INSTANCE.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(intSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot).isInstanceOf(TtlAwareSerializerSnapshot.class);
        Assertions.assertThat((Object)((IntSerializer)((TtlAwareSerializer)serializerSnapshot.restoreSerializer()).getOriginalTypeSerializer())).isInstanceOf(IntSerializer.class);
    }

    @Test
    public void testRestoreValueSerializer() {
        TypeSerializerSnapshot intSerializerSnapshot = IntSerializer.INSTANCE.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(intSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot.restoreSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((Object)((IntSerializer)((TtlAwareSerializer)serializerSnapshot.restoreSerializer()).getOriginalTypeSerializer())).isInstanceOf(IntSerializer.class);
    }

    @Test
    public void testListStateTtlAwareSerializerSnapshot() {
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)IntSerializer.INSTANCE);
        TypeSerializerSnapshot listTypeSerializerSnapshot = listSerializer.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(listTypeSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot).isInstanceOf(ListSerializerSnapshot.class);
        Assertions.assertThat((Object)((ListSerializerSnapshot)serializerSnapshot).getElementSerializerSnapshot()).isInstanceOf(TtlAwareSerializerSnapshot.class);
    }

    @Test
    public void testRestoreListSerializer() {
        ListSerializer listSerializer = new ListSerializer((TypeSerializer)IntSerializer.INSTANCE);
        TypeSerializerSnapshot listTypeSerializerSnapshot = listSerializer.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(listTypeSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot.restoreSerializer()).isInstanceOf(ListSerializer.class);
        Assertions.assertThat((Object)((ListSerializer)serializerSnapshot.restoreSerializer()).getElementSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((Object)((TtlAwareSerializer)((ListSerializer)serializerSnapshot.restoreSerializer()).getElementSerializer()).getOriginalTypeSerializer()).isInstanceOf(IntSerializer.class);
    }

    @Test
    public void testMapStateTtlAwareSerializerSnapshot() {
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        TypeSerializerSnapshot mapSerializerSnapshot = mapSerializer.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(mapSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot).isInstanceOf(MapSerializerSnapshot.class);
        Assertions.assertThat((Object)((MapSerializerSnapshot)serializerSnapshot).getValueSerializerSnapshot()).isInstanceOf(TtlAwareSerializerSnapshot.class);
    }

    @Test
    public void testRestoreMapSerializer() {
        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        TypeSerializerSnapshot mapSerializerSnapshot = mapSerializer.snapshotConfiguration();
        TypeSerializerSnapshot serializerSnapshot = new TtlAwareSerializerSnapshotWrapper(mapSerializerSnapshot).getTtlAwareSerializerSnapshot();
        Assertions.assertThat((Object)serializerSnapshot.restoreSerializer()).isInstanceOf(MapSerializer.class);
        Assertions.assertThat((Object)((MapSerializer)serializerSnapshot.restoreSerializer()).getValueSerializer()).isInstanceOf(TtlAwareSerializer.class);
        Assertions.assertThat((Object)((TtlAwareSerializer)((MapSerializer)serializerSnapshot.restoreSerializer()).getValueSerializer()).getOriginalTypeSerializer()).isInstanceOf(StringSerializer.class);
    }
}

