/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.topology.Result;
import org.apache.flink.util.IterableUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DefaultExecutionVertexTest {
    private final TestExecutionStateSupplier stateSupplier = new TestExecutionStateSupplier();
    private DefaultExecutionVertex producerVertex;
    private DefaultExecutionVertex consumerVertex;
    private IntermediateResultPartitionID intermediateResultPartitionId;

    DefaultExecutionVertexTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.intermediateResultPartitionId = new IntermediateResultPartitionID();
        DefaultResultPartition schedulingResultPartition = new DefaultResultPartition(this.intermediateResultPartitionId, new IntermediateDataSetID(), ResultPartitionType.BLOCKING, () -> ResultPartitionState.CREATED, () -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        });
        this.producerVertex = new DefaultExecutionVertex(new ExecutionVertexID(new JobVertexID(), 0), Collections.singletonList(schedulingResultPartition), (Supplier)this.stateSupplier, Collections.emptyList(), partitionID -> {
            throw new UnsupportedOperationException();
        });
        schedulingResultPartition.setProducer(this.producerVertex);
        List<ConsumedPartitionGroup> consumedPartitionGroups = Collections.singletonList(ConsumedPartitionGroup.fromSinglePartition((int)1, (IntermediateResultPartitionID)this.intermediateResultPartitionId, (ResultPartitionType)schedulingResultPartition.getResultType()));
        Map<IntermediateResultPartitionID, DefaultResultPartition> resultPartitionById = Collections.singletonMap(this.intermediateResultPartitionId, schedulingResultPartition);
        this.consumerVertex = new DefaultExecutionVertex(new ExecutionVertexID(new JobVertexID(), 0), Collections.emptyList(), (Supplier)this.stateSupplier, consumedPartitionGroups, resultPartitionById::get);
    }

    @Test
    void testGetExecutionState() {
        for (ExecutionState state : ExecutionState.values()) {
            this.stateSupplier.setExecutionState(state);
            Assertions.assertThat((Comparable)this.producerVertex.getState()).isEqualTo((Object)state);
        }
    }

    @Test
    void testGetProducedResultPartitions() {
        IntermediateResultPartitionID partitionIds1 = IterableUtils.toStream((Iterable)this.producerVertex.getProducedResults()).findAny().map(Result::getId).orElseThrow(() -> new IllegalArgumentException("can not find result partition"));
        Assertions.assertThat((Object)this.intermediateResultPartitionId).isEqualTo((Object)partitionIds1);
    }

    @Test
    void testGetConsumedResultPartitions() {
        IntermediateResultPartitionID partitionIds1 = IterableUtils.toStream((Iterable)this.consumerVertex.getConsumedResults()).findAny().map(Result::getId).orElseThrow(() -> new IllegalArgumentException("can not find result partition"));
        Assertions.assertThat((Object)this.intermediateResultPartitionId).isEqualTo((Object)partitionIds1);
    }

    private static class TestExecutionStateSupplier
    implements Supplier<ExecutionState> {
        private ExecutionState executionState;

        private TestExecutionStateSupplier() {
        }

        void setExecutionState(ExecutionState state) {
            this.executionState = state;
        }

        @Override
        public ExecutionState get() {
            return this.executionState;
        }
    }
}

