/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import org.apache.flink.runtime.rest.HttpMethodWrapper;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.RuntimeMessageHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class TestMessageHeaders<REQ extends RequestBody, RES extends ResponseBody, M extends MessageParameters>
implements RuntimeMessageHeaders<REQ, RES, M> {
    private final Class<REQ> requestClass;
    private final Class<RES> responseClass;
    private final HttpResponseStatus responseStatusCode;
    private final String description;
    private final M messageParameters;
    private final HttpMethodWrapper httpMethod;
    private final String targetRestEndpointURL;

    public static Builder<EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters> emptyBuilder() {
        return new Builder<EmptyRequestBody, EmptyResponseBody, EmptyMessageParameters>(EmptyRequestBody.class, EmptyResponseBody.class, EmptyMessageParameters.getInstance());
    }

    public static <MREQ extends RequestBody, MRES extends ResponseBody, MM extends MessageParameters> Builder<MREQ, MRES, MM> builder(Class<MREQ> requestClass, Class<MRES> responseClass, MM messageParameters) {
        return new Builder<MREQ, MRES, MM>(requestClass, responseClass, messageParameters);
    }

    private TestMessageHeaders(Class<REQ> requestClass, Class<RES> responseClass, HttpResponseStatus responseStatusCode, String description, M messageParameters, HttpMethodWrapper httpMethod, String targetRestEndpointURL) {
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.responseStatusCode = responseStatusCode;
        this.description = description;
        this.messageParameters = messageParameters;
        this.httpMethod = httpMethod;
        this.targetRestEndpointURL = targetRestEndpointURL;
    }

    public Class<RES> getResponseClass() {
        return this.responseClass;
    }

    public HttpResponseStatus getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<REQ> getRequestClass() {
        return this.requestClass;
    }

    public M getUnresolvedMessageParameters() {
        return this.messageParameters;
    }

    public HttpMethodWrapper getHttpMethod() {
        return this.httpMethod;
    }

    public String getTargetRestEndpointURL() {
        return this.targetRestEndpointURL;
    }

    public static class Builder<BREQ extends RequestBody, BRES extends ResponseBody, BM extends MessageParameters> {
        private Class<BREQ> requestClass;
        private Class<BRES> responseClass;
        private HttpResponseStatus responseStatusCode = HttpResponseStatus.OK;
        private String description = "Test description";
        private BM messageParameters;
        private HttpMethodWrapper httpMethod = HttpMethodWrapper.GET;
        private String targetRestEndpointURL = "/test-endpoint";

        private Builder(Class<BREQ> requestClass, Class<BRES> responseClass, BM messageParameters) {
            this.requestClass = requestClass;
            this.responseClass = responseClass;
            this.messageParameters = messageParameters;
        }

        public Builder<BREQ, BRES, BM> setResponseStatusCode(HttpResponseStatus responseStatusCode) {
            this.responseStatusCode = responseStatusCode;
            return this;
        }

        public Builder<BREQ, BRES, BM> setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder<BREQ, BRES, BM> setHttpMethod(HttpMethodWrapper httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder<BREQ, BRES, BM> setTargetRestEndpointURL(String targetRestEndpointURL) {
            this.targetRestEndpointURL = targetRestEndpointURL;
            return this;
        }

        public TestMessageHeaders<BREQ, BRES, BM> build() {
            return new TestMessageHeaders<BREQ, BRES, BM>(this.requestClass, this.responseClass, this.responseStatusCode, this.description, this.messageParameters, this.httpMethod, this.targetRestEndpointURL);
        }
    }
}

