/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.JobsOverviewHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionConfigBuilder;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobsOverviewHeaders;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.testutils.TestingUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JobsOverviewHandlerTest {
    private JobsOverviewHandler jobsOverviewHandler;
    private HandlerRequest<EmptyRequestBody> handlerRequest;
    private AccessExecutionGraph archivedExecutionGraph;
    private TestingRestfulGateway testingRestfulGateway;

    JobsOverviewHandlerTest() {
    }

    private static HandlerRequest<EmptyRequestBody> createRequest() throws HandlerRequestException {
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new TaskManagerMessageParameters(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    @BeforeEach
    void setUp() throws HandlerRequestException {
        GatewayRetriever leaderRetriever = () -> CompletableFuture.completedFuture(null);
        ArchivedExecutionConfig archivedExecutionConfig = new ArchivedExecutionConfigBuilder().build();
        this.jobsOverviewHandler = new JobsOverviewHandler(leaderRetriever, TestingUtils.TIMEOUT, Collections.emptyMap(), (MessageHeaders)JobsOverviewHeaders.getInstance());
        this.handlerRequest = JobsOverviewHandlerTest.createRequest();
        this.archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setArchivedExecutionConfig(archivedExecutionConfig).setPendingOperatorCounts(1).build();
        this.testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestMultipleJobDetailsSupplier(() -> CompletableFuture.completedFuture(new MultipleJobsDetails(Collections.singleton(JobDetails.createDetailsForJob((AccessExecutionGraph)this.archivedExecutionGraph)))))).build();
    }

    @Test
    void testGetJobsOverviewWithPendingOperators() throws RestHandlerException, ExecutionException, InterruptedException {
        MultipleJobsDetails multiDetails = (MultipleJobsDetails)this.jobsOverviewHandler.handleRequest(this.handlerRequest, (RestfulGateway)this.testingRestfulGateway).get();
        Assertions.assertThat((Collection)multiDetails.getJobs()).hasSize(1);
        Assertions.assertThat((int)((JobDetails)multiDetails.getJobs().iterator().next()).getPendingOperators()).isEqualTo(this.archivedExecutionGraph.getPendingOperatorCount());
    }
}

