/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorCoordinatorMetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.groups.InternalOperatorCoordinatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.CoordinatorStoreImpl;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;

public class MockOperatorCoordinatorContext
implements OperatorCoordinator.Context {
    private final JobID jobID = new JobID();
    private final OperatorID operatorID;
    private final ClassLoader userCodeClassLoader;
    private final int numSubtasks;
    private final CoordinatorStore coordinatorStore = new CoordinatorStoreImpl();
    private boolean jobFailed;
    private Throwable jobFailureReason;
    private final CompletableFuture<Void> jobFailedFuture = new CompletableFuture();

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks) {
        this(operatorID, numSubtasks, MockOperatorCoordinatorContext.class.getClassLoader());
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, ClassLoader userCodeClassLoader) {
        this(operatorID, 1, userCodeClassLoader);
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks, ClassLoader userCodeClassLoader) {
        this.operatorID = operatorID;
        this.numSubtasks = numSubtasks;
        this.jobFailed = false;
        this.jobFailureReason = null;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public OperatorCoordinatorMetricGroup metricGroup() {
        return new InternalOperatorCoordinatorMetricGroup((MetricGroup)UnregisteredMetricGroups.createUnregisteredJobManagerOperatorMetricGroup());
    }

    public void failJob(Throwable cause) {
        this.jobFailed = true;
        this.jobFailureReason = cause;
        this.jobFailedFuture.complete(null);
    }

    public int currentParallelism() {
        return this.numSubtasks;
    }

    public ClassLoader getUserCodeClassloader() {
        return this.userCodeClassLoader;
    }

    public CoordinatorStore getCoordinatorStore() {
        return this.coordinatorStore;
    }

    public boolean isConcurrentExecutionAttemptsSupported() {
        return false;
    }

    public CheckpointCoordinator getCheckpointCoordinator() {
        return null;
    }

    public boolean isJobFailed() {
        return this.jobFailed;
    }

    public Throwable getJobFailureReason() {
        return this.jobFailureReason;
    }

    public CompletableFuture<Void> getJobFailedFuture() {
        return this.jobFailedFuture;
    }
}

