/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.forwardgroup;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.forwardgroup.StreamNodeForwardGroup;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamNodeForwardGroupTest {
    StreamNodeForwardGroupTest() {
    }

    @Test
    void testStreamNodeForwardGroup() {
        HashSet<StreamNode> streamNodes = new HashSet<StreamNode>();
        streamNodes.add(StreamNodeForwardGroupTest.createStreamNode(0, 1, 1));
        streamNodes.add(StreamNodeForwardGroupTest.createStreamNode(1, 1, 1));
        StreamNodeForwardGroup forwardGroup = new StreamNodeForwardGroup(streamNodes);
        Assertions.assertThat((int)forwardGroup.getParallelism()).isEqualTo(1);
        Assertions.assertThat((int)forwardGroup.getMaxParallelism()).isEqualTo(1);
        Assertions.assertThat((int)forwardGroup.size()).isEqualTo(2);
        streamNodes.add(StreamNodeForwardGroupTest.createStreamNode(3, 1, 1));
        StreamNodeForwardGroup forwardGroup2 = new StreamNodeForwardGroup(streamNodes);
        Assertions.assertThat((int)forwardGroup2.size()).isEqualTo(3);
    }

    @Test
    void testMergeForwardGroup() {
        HashMap<Integer, StreamNode> streamNodeRetriever = new HashMap<Integer, StreamNode>();
        StreamNodeForwardGroup forwardGroup = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(0, -1, -1), streamNodeRetriever);
        StreamNodeForwardGroup forwardGroupWithUnDecidedParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(1, -1, -1), streamNodeRetriever);
        forwardGroup.mergeForwardGroup(forwardGroupWithUnDecidedParallelism);
        Assertions.assertThat((boolean)forwardGroup.isParallelismDecided()).isFalse();
        Assertions.assertThat((boolean)forwardGroup.isMaxParallelismDecided()).isFalse();
        StreamNodeForwardGroup forwardGroupWithDecidedParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(2, 2, 4), streamNodeRetriever);
        forwardGroup.mergeForwardGroup(forwardGroupWithDecidedParallelism);
        Assertions.assertThat((int)forwardGroup.getParallelism()).isEqualTo(2);
        Assertions.assertThat((int)forwardGroup.getMaxParallelism()).isEqualTo(4);
        StreamNodeForwardGroup forwardGroupWithLargerMaxParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(3, 2, 5), streamNodeRetriever);
        Assertions.assertThat((boolean)forwardGroup.mergeForwardGroup(forwardGroupWithLargerMaxParallelism)).isTrue();
        Assertions.assertThat((int)forwardGroup.getMaxParallelism()).isEqualTo(4);
        StreamNodeForwardGroup forwardGroupWithSmallerMaxParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(4, 2, 3), streamNodeRetriever);
        Assertions.assertThat((boolean)forwardGroup.mergeForwardGroup(forwardGroupWithSmallerMaxParallelism)).isTrue();
        Assertions.assertThat((int)forwardGroup.getMaxParallelism()).isEqualTo(3);
        StreamNodeForwardGroup forwardGroupWithMaxParallelismSmallerThanSourceParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(5, -1, 1), streamNodeRetriever);
        Assertions.assertThat((boolean)forwardGroup.mergeForwardGroup(forwardGroupWithMaxParallelismSmallerThanSourceParallelism)).isFalse();
        StreamNodeForwardGroup forwardGroupWithDifferentParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(6, 1, 3), streamNodeRetriever);
        Assertions.assertThat((boolean)forwardGroup.mergeForwardGroup(forwardGroupWithDifferentParallelism)).isFalse();
        StreamNodeForwardGroup forwardGroupWithUndefinedParallelism = this.createForwardGroupAndUpdateStreamNodeRetriever(StreamNodeForwardGroupTest.createStreamNode(7, -1, 2), streamNodeRetriever);
        Assertions.assertThat((boolean)forwardGroup.mergeForwardGroup(forwardGroupWithUndefinedParallelism)).isTrue();
        Assertions.assertThat((int)forwardGroup.size()).isEqualTo(6);
        Assertions.assertThat((int)forwardGroup.getParallelism()).isEqualTo(2);
        Assertions.assertThat((int)forwardGroup.getMaxParallelism()).isEqualTo(2);
        for (Integer nodeId : forwardGroup.getVertexIds()) {
            StreamNode node = (StreamNode)streamNodeRetriever.get(nodeId);
            Assertions.assertThat((int)node.getParallelism()).isEqualTo(forwardGroup.getParallelism());
            Assertions.assertThat((int)node.getMaxParallelism()).isEqualTo(forwardGroup.getMaxParallelism());
        }
    }

    private static StreamNode createStreamNode(int id, int parallelism, int maxParallelism) {
        StreamNode streamNode = new StreamNode(Integer.valueOf(id), null, null, (StreamOperator)null, null, null);
        if (parallelism > 0) {
            streamNode.setParallelism(Integer.valueOf(parallelism));
        }
        if (maxParallelism > 0) {
            streamNode.setMaxParallelism(maxParallelism);
        }
        return streamNode;
    }

    private StreamNodeForwardGroup createForwardGroupAndUpdateStreamNodeRetriever(StreamNode streamNode, Map<Integer, StreamNode> streamNodeRetriever) {
        streamNodeRetriever.put(streamNode.getId(), streamNode);
        return new StreamNodeForwardGroup(Collections.singleton(streamNode));
    }
}

