/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TestingNettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierSubpartitionProducerAgent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MemoryTierSubpartitionProducerAgentTest {
    MemoryTierSubpartitionProducerAgentTest() {
    }

    @Test
    void testConnectionEstablished() {
        MemoryTierSubpartitionProducerAgent subpartitionProducerAgent = MemoryTierSubpartitionProducerAgentTest.createSubpartitionProducerAgent();
        Assertions.assertThatThrownBy(() -> subpartitionProducerAgent.addFinishedBuffer(BufferBuilderTestUtils.buildSomeBuffer())).isInstanceOf(NullPointerException.class);
        subpartitionProducerAgent.connectionEstablished((NettyConnectionWriter)new TestingNettyConnectionWriter.Builder().build());
        Assertions.assertThatCode(() -> subpartitionProducerAgent.addFinishedBuffer(BufferBuilderTestUtils.buildSomeBuffer())).doesNotThrowAnyException();
    }

    @Test
    void testAddFinishedBuffer() {
        MemoryTierSubpartitionProducerAgent subpartitionProducerAgent = MemoryTierSubpartitionProducerAgentTest.createSubpartitionProducerAgent();
        AtomicReference received = new AtomicReference();
        TestingNettyConnectionWriter connectionWriter = new TestingNettyConnectionWriter.Builder().setWriteBufferFunction(buffer -> {
            received.set(buffer);
            return null;
        }).build();
        subpartitionProducerAgent.connectionEstablished((NettyConnectionWriter)connectionWriter);
        Buffer sentBuffer = BufferBuilderTestUtils.buildSomeBuffer();
        subpartitionProducerAgent.addFinishedBuffer(sentBuffer);
        Optional receivedBuffer = ((NettyPayload)received.get()).getBuffer();
        Assertions.assertThat((Optional)receivedBuffer).isPresent();
        Assertions.assertThat((Object)((Buffer)receivedBuffer.get())).isEqualTo((Object)sentBuffer);
    }

    @Test
    void testUpdateSegmentId() {
        int segmentId = 1;
        MemoryTierSubpartitionProducerAgent subpartitionProducerAgent = MemoryTierSubpartitionProducerAgentTest.createSubpartitionProducerAgent();
        AtomicReference received = new AtomicReference();
        TestingNettyConnectionWriter connectionWriter = new TestingNettyConnectionWriter.Builder().setWriteBufferFunction(buffer -> {
            received.set(buffer);
            return null;
        }).build();
        subpartitionProducerAgent.connectionEstablished((NettyConnectionWriter)connectionWriter);
        subpartitionProducerAgent.updateSegmentId(segmentId);
        Assertions.assertThat((int)((NettyPayload)received.get()).getSegmentId()).isEqualTo(segmentId);
    }

    @Test
    void testRelease() {
        MemoryTierSubpartitionProducerAgent subpartitionProducerAgent = MemoryTierSubpartitionProducerAgentTest.createSubpartitionProducerAgent();
        AtomicBoolean isClosed = new AtomicBoolean(false);
        TestingNettyConnectionWriter connectionWriter = new TestingNettyConnectionWriter.Builder().setCloseFunction(throwable -> {
            isClosed.set(true);
            return null;
        }).build();
        subpartitionProducerAgent.connectionEstablished((NettyConnectionWriter)connectionWriter);
        subpartitionProducerAgent.release();
        Assertions.assertThat((AtomicBoolean)isClosed).isTrue();
    }

    private static MemoryTierSubpartitionProducerAgent createSubpartitionProducerAgent() {
        return new MemoryTierSubpartitionProducerAgent(0);
    }
}

