/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava32.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;

@Internal
public class OneInputTransformation<IN, OUT>
extends PhysicalTransformation<OUT> {
    private final Transformation<IN> input;
    private final StreamOperatorFactory<OUT> operatorFactory;
    private KeySelector<IN, ?> stateKeySelector;
    private TypeInformation<?> stateKeyType;

    public OneInputTransformation(Transformation<IN> input, String name, OneInputStreamOperator<IN, OUT> operator, TypeInformation<OUT> outputType, int parallelism) {
        this(input, name, SimpleOperatorFactory.of(operator), outputType, parallelism);
    }

    public OneInputTransformation(Transformation<IN> input, String name, OneInputStreamOperator<IN, OUT> operator, TypeInformation<OUT> outputType, int parallelism, boolean parallelismConfigured) {
        this(input, name, SimpleOperatorFactory.of(operator), outputType, parallelism, parallelismConfigured);
    }

    public OneInputTransformation(Transformation<IN> input, String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    public OneInputTransformation(Transformation<IN> input, String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism, boolean parallelismConfigured) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.input = input;
        this.operatorFactory = operatorFactory;
    }

    public TypeInformation<IN> getInputType() {
        return this.input.getOutputType();
    }

    @VisibleForTesting
    public OneInputStreamOperator<IN, OUT> getOperator() {
        return (OneInputStreamOperator)((SimpleOperatorFactory)this.operatorFactory).getOperator();
    }

    public StreamOperatorFactory<OUT> getOperatorFactory() {
        return this.operatorFactory;
    }

    public void setStateKeySelector(KeySelector<IN, ?> stateKeySelector) {
        this.stateKeySelector = stateKeySelector;
        this.updateManagedMemoryStateBackendUseCase(stateKeySelector != null);
    }

    public KeySelector<IN, ?> getStateKeySelector() {
        return this.stateKeySelector;
    }

    public void setStateKeyType(TypeInformation<?> stateKeyType) {
        this.stateKeyType = stateKeyType;
    }

    public TypeInformation<?> getStateKeyType() {
        return this.stateKeyType;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }

    public boolean isOutputOnlyAfterEndOfStream() {
        return this.operatorFactory.getOperatorAttributes().isOutputOnlyAfterEndOfStream();
    }

    public boolean isInternalSorterSupported() {
        return this.operatorFactory.getOperatorAttributes().isInternalSorterSupported();
    }

    public void enableAsyncState() {
        OneInputStreamOperator operator = (OneInputStreamOperator)((SimpleOperatorFactory)this.operatorFactory).getOperator();
        if (!(operator instanceof AsyncStateProcessingOperator)) {
            super.enableAsyncState();
        }
    }
}

