/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.windowing;

import java.util.Collections;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.AllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Internal
public class ReduceApplyAllWindowFunction<W extends Window, T, R>
extends WrappingFunction<AllWindowFunction<T, R, W>>
implements AllWindowFunction<T, R, W> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReduceApplyAllWindowFunction(ReduceFunction<T> reduceFunction, AllWindowFunction<T, R, W> windowFunction) {
        super(windowFunction);
        this.reduceFunction = reduceFunction;
    }

    @Override
    public void apply(W window, Iterable<T> input, Collector<R> out) throws Exception {
        Object curr = null;
        for (T val : input) {
            if (curr == null) {
                curr = val;
                continue;
            }
            curr = this.reduceFunction.reduce(curr, val);
        }
        ((AllWindowFunction)this.wrappedFunction).apply(window, Collections.singletonList(curr), out);
    }
}

