/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.guava32.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobInformation
implements Serializable {
    private static final long serialVersionUID = 8367087049937822140L;
    private final JobID jobId;
    private final JobType jobType;
    private final String jobName;
    private final SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private final UnmodifiableConfiguration jobConfiguration;
    private final ImmutableCollection<PermanentBlobKey> requiredJarFileBlobKeys;
    private final ImmutableCollection<URL> requiredClasspathURLs;

    public JobInformation(JobID jobId, JobType jobType, String jobName, SerializedValue<ExecutionConfig> serializedExecutionConfig, Configuration jobConfiguration, Collection<PermanentBlobKey> requiredJarFileBlobKeys, Collection<URL> requiredClasspathURLs) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.jobType = (JobType)((Object)Preconditions.checkNotNull((Object)((Object)jobType)));
        this.jobName = (String)Preconditions.checkNotNull((Object)jobName);
        this.serializedExecutionConfig = (SerializedValue)Preconditions.checkNotNull(serializedExecutionConfig);
        this.jobConfiguration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)jobConfiguration));
        this.requiredJarFileBlobKeys = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(requiredJarFileBlobKeys)));
        this.requiredClasspathURLs = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(requiredClasspathURLs)));
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig() {
        return this.serializedExecutionConfig;
    }

    public UnmodifiableConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public ImmutableCollection<PermanentBlobKey> getRequiredJarFileBlobKeys() {
        return this.requiredJarFileBlobKeys;
    }

    public ImmutableCollection<URL> getRequiredClasspathURLs() {
        return this.requiredClasspathURLs;
    }

    public JobInformation deepCopy() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobInformation that = (JobInformation)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.jobName, that.jobName) && Objects.equals(this.serializedExecutionConfig, that.serializedExecutionConfig) && Objects.equals(this.jobConfiguration, that.jobConfiguration) && Objects.equals(this.requiredJarFileBlobKeys, that.requiredJarFileBlobKeys) && Objects.equals(this.requiredClasspathURLs, that.requiredClasspathURLs);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.jobName, this.serializedExecutionConfig, this.jobConfiguration, this.requiredJarFileBlobKeys, this.requiredClasspathURLs);
    }

    public String toString() {
        return "JobInformation for '" + this.jobName + "' (" + this.jobId + ")";
    }
}

