/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEvent;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionListener;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionDriver;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriver;
import org.apache.flink.runtime.leaderretrieval.ZooKeeperLeaderRetrievalDriverFactory;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterables;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.RunnableWithException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ZooKeeperLeaderElectionDriverTest {
    private final ZooKeeperExtension zooKeeperExtension = new ZooKeeperExtension();
    @RegisterExtension
    private final EachCallbackWrapper<ZooKeeperExtension> eachWrapper = new EachCallbackWrapper((CustomExtension)this.zooKeeperExtension);
    @RegisterExtension
    final TestingFatalErrorHandlerExtension testingFatalErrorHandlerResource = new TestingFatalErrorHandlerExtension();

    ZooKeeperLeaderElectionDriverTest() {
    }

    @Test
    void testElectionDriverGainsLeadershipAtStartup() throws Exception {
        new Context(){
            {
                this.runTest(() -> this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class));
            }
        };
    }

    @Test
    void testElectionDriverLosesLeadership() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                    ZooKeeperLeaderElectionDriverTest.this.zooKeeperExtension.stop();
                    this.leaderElectionListener.await(LeaderElectionEvent.NotLeaderEvent.class);
                });
            }
        };
    }

    @Test
    void testPublishLeaderInformation() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                    String componentId = "retrieved-component";
                    DefaultLeaderRetrievalService defaultLeaderRetrievalService = new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)new ZooKeeperLeaderRetrievalDriverFactory(this.curatorFramework.asCuratorFramework(), "retrieved-component", ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_LOST_CONNECTION));
                    TestingListener leaderRetrievalListener = new TestingListener();
                    defaultLeaderRetrievalService.start((LeaderRetrievalListener)leaderRetrievalListener);
                    LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"foobar");
                    this.leaderElectionDriver.publishLeaderInformation("retrieved-component", leaderInformation);
                    leaderRetrievalListener.waitForNewLeader();
                    Assertions.assertThat((Object)leaderRetrievalListener.getLeader()).isEqualTo((Object)leaderInformation);
                });
            }
        };
    }

    @Test
    void testPublishEmptyLeaderInformation() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                    String componentId = "retrieved-component";
                    DefaultLeaderRetrievalService defaultLeaderRetrievalService = new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)new ZooKeeperLeaderRetrievalDriverFactory(this.curatorFramework.asCuratorFramework(), "retrieved-component", ZooKeeperLeaderRetrievalDriver.LeaderInformationClearancePolicy.ON_LOST_CONNECTION));
                    TestingListener leaderRetrievalListener = new TestingListener();
                    defaultLeaderRetrievalService.start((LeaderRetrievalListener)leaderRetrievalListener);
                    this.leaderElectionDriver.publishLeaderInformation("retrieved-component", LeaderInformation.known((UUID)UUID.randomUUID(), (String)"foobar"));
                    leaderRetrievalListener.waitForNewLeader();
                    this.leaderElectionDriver.publishLeaderInformation("retrieved-component", LeaderInformation.empty());
                    leaderRetrievalListener.waitForEmptyLeaderInformation();
                    Assertions.assertThat((Object)leaderRetrievalListener.getLeader()).isEqualTo((Object)LeaderInformation.empty());
                });
            }
        };
    }

    @Test
    void testToStringContainingLeaderLatchPath() throws Exception {
        new Context(){
            {
                this.runTest(() -> ((AbstractStringAssert)Assertions.assertThat((String)this.leaderElectionDriver.toString()).as("toString() should contain the leader latch path for human-readable representation of the driver instance.", new Object[0])).contains(new CharSequence[]{ZooKeeperUtils.generateLeaderLatchPath((String)this.curatorFramework.asCuratorFramework().getNamespace())}));
            }
        };
    }

    @Test
    void testNonLeaderCannotPublishLeaderInformation() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    try (ElectionDriver otherLeaderElectionDriver = null;){
                        this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                        otherLeaderElectionDriver = ZooKeeperLeaderElectionDriverTest.createLeaderElectionDriver(this.curatorFramework.asCuratorFramework(), ZooKeeperLeaderElectionDriverTest.this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler());
                        Assertions.assertThat((boolean)otherLeaderElectionDriver.hasLeadership()).isFalse();
                        otherLeaderElectionDriver.publishLeaderInformation("component-id", LeaderInformation.known((UUID)UUID.randomUUID(), (String)"localhost"));
                        Assertions.assertThat(this.leaderElectionListener.await(LeaderElectionEvent.LeaderInformationChangeEvent.class, Duration.ofMillis(50L))).isEmpty();
                    }
                });
            }
        };
    }

    @Test
    void testLeaderInformationChange() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                    LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"foobar");
                    String componentId = "componentId";
                    String path = ZooKeeperUtils.generateConnectionInformationPath((String)"componentId");
                    ZooKeeperUtils.writeLeaderInformationToZooKeeper((LeaderInformation)leaderInformation, (CuratorFramework)this.curatorFramework.asCuratorFramework(), () -> true, (String)path);
                    LeaderElectionEvent.LeaderInformationChangeEvent leaderInformationChangeEvent = this.leaderElectionListener.await(LeaderElectionEvent.LeaderInformationChangeEvent.class);
                    Assertions.assertThat((String)leaderInformationChangeEvent.getComponentId()).isEqualTo("componentId");
                    Assertions.assertThat((Object)leaderInformationChangeEvent.getLeaderInformation()).isEqualTo((Object)leaderInformation);
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLeaderElectionWithMultipleDrivers() throws Exception {
        try (CuratorFrameworkWithUnhandledErrorListener curatorFramework = this.startCuratorFramework();){
            Set electionDrivers = Stream.generate(() -> ZooKeeperLeaderElectionDriverTest.createLeaderElectionDriver(curatorFramework.asCuratorFramework(), this.testingFatalErrorHandlerResource.getTestingFatalErrorHandler())).limit(3L).collect(Collectors.toSet());
            while (!electionDrivers.isEmpty()) {
                CompletableFuture<Object> anyLeader = CompletableFuture.anyOf((CompletableFuture[])electionDrivers.stream().map(ElectionDriver::getLeadershipFuture).toArray(CompletableFuture[]::new));
                anyLeader.join();
                Map leaderAndRest = electionDrivers.stream().collect(Collectors.partitioningBy(ElectionDriver::hasLeadership, Collectors.toSet()));
                Assertions.assertThat((Collection)leaderAndRest.get(true)).hasSize(1);
                Thread.sleep(100L);
                ((ElectionDriver)Iterables.getOnlyElement((Iterable)leaderAndRest.get(true))).close();
                electionDrivers = leaderAndRest.get(false);
            }
        }
    }

    @Test
    void testLeaderInformationNodeRemovalLeadsToLeaderChangeWithEmptyLeaderInformation() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    this.leaderElectionListener.await(LeaderElectionEvent.IsLeaderEvent.class);
                    LeaderInformation leaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"foobar");
                    String componentId = "componentId";
                    String path = ZooKeeperUtils.generateConnectionInformationPath((String)"componentId");
                    ZooKeeperUtils.writeLeaderInformationToZooKeeper((LeaderInformation)leaderInformation, (CuratorFramework)this.curatorFramework.asCuratorFramework(), () -> true, (String)path);
                    this.leaderElectionListener.await(LeaderElectionEvent.LeaderInformationChangeEvent.class);
                    this.curatorFramework.asCuratorFramework().delete().forPath(path);
                    LeaderElectionEvent.LeaderInformationChangeEvent leaderInformationChangeEvent = this.leaderElectionListener.await(LeaderElectionEvent.LeaderInformationChangeEvent.class);
                    Assertions.assertThat((String)leaderInformationChangeEvent.getComponentId()).isEqualTo("componentId");
                    Assertions.assertThat((Object)leaderInformationChangeEvent.getLeaderInformation()).isEqualTo((Object)LeaderInformation.empty());
                });
            }
        };
    }

    private static ElectionDriver createLeaderElectionDriver(CuratorFramework curatorFramework, FatalErrorHandler fatalErrorHandler) {
        SimpleLeaderElectionListener leaderElectionListener = new SimpleLeaderElectionListener(fatalErrorHandler);
        try {
            ZooKeeperLeaderElectionDriver leaderElectionDriver = new ZooKeeperLeaderElectionDriver(curatorFramework, (LeaderElectionDriver.Listener)leaderElectionListener);
            return new ElectionDriver(leaderElectionDriver, leaderElectionListener);
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
            return null;
        }
    }

    private CuratorFrameworkWithUnhandledErrorListener startCuratorFramework() {
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)this.zooKeeperExtension.getConnectString());
        return ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
    }

    private class Context {
        protected final TestingLeaderElectionListener leaderElectionListener = new TestingLeaderElectionListener();
        protected final CuratorFrameworkWithUnhandledErrorListener curatorFramework;
        protected final ZooKeeperLeaderElectionDriver leaderElectionDriver;

        private Context() throws Exception {
            this.curatorFramework = ZooKeeperLeaderElectionDriverTest.this.startCuratorFramework();
            this.leaderElectionDriver = new ZooKeeperLeaderElectionDriver(this.curatorFramework.asCuratorFramework(), (LeaderElectionDriver.Listener)this.leaderElectionListener);
        }

        protected final void runTest(RunnableWithException test) throws Exception {
            try {
                test.run();
            }
            finally {
                this.close();
                this.leaderElectionListener.failIfErrorEventHappened();
            }
        }

        private void close() throws Exception {
            this.leaderElectionDriver.close();
            this.curatorFramework.close();
        }
    }

    private static final class SimpleLeaderElectionListener
    implements LeaderElectionDriver.Listener {
        private final CompletableFuture<Void> leadershipFuture = new CompletableFuture();
        private final FatalErrorHandler fatalErrorHandler;

        public SimpleLeaderElectionListener(FatalErrorHandler fatalErrorHandler) {
            this.fatalErrorHandler = fatalErrorHandler;
        }

        CompletableFuture<Void> getLeadershipFuture() {
            return this.leadershipFuture;
        }

        public void onGrantLeadership(UUID ignoredSessionID) {
            this.leadershipFuture.complete(null);
        }

        public void onRevokeLeadership() {
        }

        public void onLeaderInformationChange(String componentId, LeaderInformation leaderInformation) {
        }

        public void onLeaderInformationChange(LeaderInformationRegister leaderInformationRegister) {
        }

        public void onError(Throwable t) {
            this.fatalErrorHandler.onFatalError(t);
        }
    }

    private static final class ElectionDriver {
        private final ZooKeeperLeaderElectionDriver leaderElectionDriver;
        private final SimpleLeaderElectionListener leaderElectionListener;

        private ElectionDriver(ZooKeeperLeaderElectionDriver leaderElectionDriver, SimpleLeaderElectionListener leaderElectionListener) {
            this.leaderElectionDriver = leaderElectionDriver;
            this.leaderElectionListener = leaderElectionListener;
        }

        void close() throws Exception {
            this.leaderElectionDriver.close();
        }

        boolean hasLeadership() {
            return this.leaderElectionDriver.hasLeadership();
        }

        CompletableFuture<Void> getLeadershipFuture() {
            return this.leaderElectionListener.getLeadershipFuture();
        }

        void publishLeaderInformation(String componentId, LeaderInformation leaderInformation) throws Exception {
            this.leaderElectionDriver.publishLeaderInformation(componentId, leaderInformation);
        }
    }
}

