/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphID;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExecutionAttemptIDTest {
    private static final NettyBufferPool ALLOCATOR = new NettyBufferPool(1);

    ExecutionAttemptIDTest() {
    }

    @Test
    void testByteBufWriteAndRead() {
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID(new ExecutionGraphID(), new ExecutionVertexID(new JobVertexID(), 123), 456);
        int byteBufLen = ExecutionAttemptID.getByteBufLength();
        ByteBuf byteBuf = ALLOCATOR.directBuffer(byteBufLen, byteBufLen);
        executionAttemptID.writeTo(byteBuf);
        Assertions.assertThat((int)byteBuf.writerIndex()).isEqualTo(ExecutionAttemptID.getByteBufLength());
        Assertions.assertThat((Object)ExecutionAttemptID.fromByteBuf((ByteBuf)byteBuf)).isEqualTo((Object)executionAttemptID);
    }
}

