/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.DefaultVertexAttemptNumberStore;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultVertexAttemptNumberStoreTest {
    DefaultVertexAttemptNumberStoreTest() {
    }

    @Test
    void testSetAttemptCount() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        JobVertexID jobVertexId = new JobVertexID();
        int subtaskIndex = 4;
        int attemptCount = 2;
        vertexAttemptNumberStore.setAttemptCount(jobVertexId, 4, 2);
        Assertions.assertThat((int)vertexAttemptNumberStore.getAttemptCounts(jobVertexId).getAttemptCount(4)).isEqualTo(2);
    }

    @Test
    void testSetAttemptCountRejectsNegativeSubtaskIndex() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        Assertions.assertThatThrownBy(() -> vertexAttemptNumberStore.setAttemptCount(new JobVertexID(), -1, 0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testSetAttemptCountRejectsNegativeAttemptCount() {
        DefaultVertexAttemptNumberStore vertexAttemptNumberStore = new DefaultVertexAttemptNumberStore();
        Assertions.assertThatThrownBy(() -> vertexAttemptNumberStore.setAttemptCount(new JobVertexID(), 0, -1)).isInstanceOf(IllegalArgumentException.class);
    }
}

