/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.legacy.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterOperator;
import org.apache.flink.util.Preconditions;

@Internal
public final class SinkWriterOperatorFactory<InputT, CommT>
extends AbstractStreamOperatorFactory<CommittableMessage<CommT>>
implements OneInputStreamOperatorFactory<InputT, CommittableMessage<CommT>>,
YieldingOperatorFactory<CommittableMessage<CommT>> {
    private final Sink<InputT> sink;

    public SinkWriterOperatorFactory(Sink<InputT> sink) {
        this.sink = (Sink)Preconditions.checkNotNull(sink);
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<CommT>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<CommT>> parameters) {
        try {
            SinkWriterOperator<InputT, CommT> writerOperator = new SinkWriterOperator<InputT, CommT>(parameters, this.sink, this.processingTimeService, this.getMailboxExecutor());
            return (T)writerOperator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create sink operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return SinkWriterOperator.class;
    }

    @VisibleForTesting
    public Sink<InputT> getSink() {
        return this.sink;
    }
}

