/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.FinishedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.FullyFinishedOperatorState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV2V3SerializerBase;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV4Serializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.Preconditions;

@Internal
public class MetadataV5Serializer
extends MetadataV4Serializer {
    public static final MetadataSerializer INSTANCE = new MetadataV5Serializer();
    public static final int VERSION = 5;

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    protected void serializeOperatorState(OperatorState operatorState, DataOutputStream dos) throws IOException {
        if (operatorState.getOperatorName().isPresent() && operatorState.getOperatorName().get().isEmpty()) {
            throw new IllegalArgumentException("Empty string operator name is not allowed");
        }
        if (operatorState.getOperatorUid().isPresent() && operatorState.getOperatorUid().get().isEmpty()) {
            throw new IllegalArgumentException("Empty string operator uid is not allowed");
        }
        dos.writeUTF(operatorState.getOperatorName().orElse(""));
        dos.writeUTF(operatorState.getOperatorUid().orElse(""));
        super.serializeOperatorState(operatorState, dos);
    }

    @Override
    protected OperatorState deserializeOperatorState(DataInputStream dis, @Nullable MetadataV2V3SerializerBase.DeserializationContext context) throws IOException {
        String name = dis.readUTF();
        String uid = dis.readUTF();
        OperatorID jobVertexId = new OperatorID(dis.readLong(), dis.readLong());
        int parallelism = dis.readInt();
        int maxParallelism = dis.readInt();
        ByteStreamStateHandle coordinateState = MetadataV5Serializer.deserializeAndCheckByteStreamStateHandle(dis, context);
        int numSubTaskStates = dis.readInt();
        if (numSubTaskStates < 0) {
            Preconditions.checkState((coordinateState == null ? 1 : 0) != 0, (Object)"Coordinator State should be null for fully finished operator state");
            return new FullyFinishedOperatorState(name.isEmpty() ? null : name, uid.isEmpty() ? null : uid, jobVertexId, parallelism, maxParallelism);
        }
        OperatorState operatorState = new OperatorState(name.isEmpty() ? null : name, uid.isEmpty() ? null : uid, jobVertexId, parallelism, maxParallelism);
        operatorState.setCoordinatorState(coordinateState);
        for (int j = 0; j < numSubTaskStates; ++j) {
            MetadataV3Serializer.SubtaskAndFinishedState subtaskAndFinishedState = this.deserializeSubtaskIndexAndFinishedState(dis);
            if (subtaskAndFinishedState.isFinished) {
                operatorState.putState(subtaskAndFinishedState.subtaskIndex, FinishedOperatorSubtaskState.INSTANCE);
                continue;
            }
            OperatorSubtaskState subtaskState = this.deserializeSubtaskState(dis, context);
            operatorState.putState(subtaskAndFinishedState.subtaskIndex, subtaskState);
        }
        return operatorState;
    }
}

