/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.AbstractBlobCache;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.TransientBlobCleanupTask;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.TransientBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Reference;
import org.slf4j.LoggerFactory;

public class TransientBlobCache
extends AbstractBlobCache
implements TransientBlobService {
    private final ConcurrentHashMap<Tuple2<JobID, TransientBlobKey>, Long> blobExpiryTimes = new ConcurrentHashMap();
    private final long cleanupInterval;
    private final Timer cleanupTimer = new Timer(true);

    @VisibleForTesting
    public TransientBlobCache(Configuration blobClientConfig, File storageDir, @Nullable InetSocketAddress serverAddress) throws IOException {
        this(blobClientConfig, (Reference<File>)Reference.owned((Object)storageDir), serverAddress);
    }

    public TransientBlobCache(Configuration blobClientConfig, Reference<File> storageDir, @Nullable InetSocketAddress serverAddress) throws IOException {
        super(blobClientConfig, storageDir, new VoidBlobStore(), LoggerFactory.getLogger(TransientBlobCache.class), serverAddress);
        this.cleanupInterval = (Long)blobClientConfig.get(BlobServerOptions.CLEANUP_INTERVAL) * 1000L;
        this.cleanupTimer.schedule((TimerTask)new TransientBlobCleanupTask(this.blobExpiryTimes, this::deleteInternal, this.log), this.cleanupInterval, this.cleanupInterval);
        this.registerBlobExpiryTimes();
    }

    private void registerBlobExpiryTimes() throws IOException {
        if (((File)this.storageDir.deref()).exists()) {
            Collection<BlobUtils.TransientBlob> transientBlobs = BlobUtils.listTransientBlobsInDirectory(((File)this.storageDir.deref()).toPath());
            long expiryTime = System.currentTimeMillis() + this.cleanupInterval;
            for (BlobUtils.TransientBlob transientBlob : transientBlobs) {
                this.blobExpiryTimes.put((Tuple2<JobID, TransientBlobKey>)Tuple2.of((Object)transientBlob.getJobId(), (Object)((TransientBlobKey)transientBlob.getBlobKey())), expiryTime);
            }
        }
    }

    @Override
    public File getFile(TransientBlobKey key) throws IOException {
        return this.getFileInternal(null, key);
    }

    @Override
    public File getFile(JobID jobId, TransientBlobKey key) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        return this.getFileInternal(jobId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File getFileInternal(@Nullable JobID jobId, BlobKey blobKey) throws IOException {
        File file = super.getFileInternal(jobId, blobKey);
        this.readWriteLock.readLock().lock();
        try {
            this.blobExpiryTimes.put((Tuple2<JobID, TransientBlobKey>)Tuple2.of((Object)jobId, (Object)((TransientBlobKey)blobKey)), System.currentTimeMillis() + this.cleanupInterval);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return file;
    }

    @Override
    public TransientBlobKey putTransient(byte[] value) throws IOException {
        try (BlobClient bc = this.createClient();){
            TransientBlobKey transientBlobKey = (TransientBlobKey)bc.putBuffer(null, value, 0, value.length, BlobKey.BlobType.TRANSIENT_BLOB);
            return transientBlobKey;
        }
    }

    @Override
    public TransientBlobKey putTransient(JobID jobId, byte[] value) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        try (BlobClient bc = this.createClient();){
            TransientBlobKey transientBlobKey = (TransientBlobKey)bc.putBuffer(jobId, value, 0, value.length, BlobKey.BlobType.TRANSIENT_BLOB);
            return transientBlobKey;
        }
    }

    @Override
    public TransientBlobKey putTransient(InputStream inputStream) throws IOException {
        try (BlobClient bc = this.createClient();){
            TransientBlobKey transientBlobKey = (TransientBlobKey)bc.putInputStream(null, inputStream, BlobKey.BlobType.TRANSIENT_BLOB);
            return transientBlobKey;
        }
    }

    @Override
    public TransientBlobKey putTransient(JobID jobId, InputStream inputStream) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        try (BlobClient bc = this.createClient();){
            TransientBlobKey transientBlobKey = (TransientBlobKey)bc.putInputStream(jobId, inputStream, BlobKey.BlobType.TRANSIENT_BLOB);
            return transientBlobKey;
        }
    }

    @Override
    public boolean deleteFromCache(TransientBlobKey key) {
        return this.deleteInternal(null, key);
    }

    @Override
    public boolean deleteFromCache(JobID jobId, TransientBlobKey key) {
        Preconditions.checkNotNull((Object)jobId);
        return this.deleteInternal(jobId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(@Nullable JobID jobId, TransientBlobKey key) {
        File localFile = new File(BlobUtils.getStorageLocationPath(((File)this.storageDir.deref()).getAbsolutePath(), jobId, key));
        this.readWriteLock.writeLock().lock();
        try {
            if (!localFile.delete() && localFile.exists()) {
                this.log.warn("Failed to delete locally cached BLOB {} at {}", (Object)key, (Object)localFile.getAbsolutePath());
                boolean bl = false;
                return bl;
            }
            this.blobExpiryTimes.remove(Tuple2.of((Object)jobId, (Object)key));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        return true;
    }

    @VisibleForTesting
    ConcurrentMap<Tuple2<JobID, TransientBlobKey>, Long> getBlobExpiryTimes() {
        return this.blobExpiryTimes;
    }

    @VisibleForTesting
    public File getStorageLocation(@Nullable JobID jobId, BlobKey key) throws IOException {
        return BlobUtils.getStorageLocation((File)this.storageDir.deref(), jobId, key);
    }

    private BlobClient createClient() throws IOException {
        InetSocketAddress currentServerAddress = this.serverAddress;
        if (currentServerAddress != null) {
            return new BlobClient(currentServerAddress, this.blobClientConfig);
        }
        throw new IOException("Could not create BlobClient because the BlobServer address is unknown.");
    }

    @Override
    protected void cancelCleanupTask() {
        this.cleanupTimer.cancel();
    }
}

