/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.deploying;

import java.util.List;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkBase;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkUtils;

public class DeployingTasksBenchmarkBase
extends SchedulerBenchmarkBase {
    List<JobVertex> jobVertices;
    ExecutionGraph executionGraph;

    public void setup(JobConfiguration jobConfiguration) throws Exception {
        super.setup();
        this.jobVertices = SchedulerBenchmarkUtils.createDefaultJobVertices(jobConfiguration);
        this.executionGraph = SchedulerBenchmarkUtils.createAndInitExecutionGraph(this.jobVertices, jobConfiguration, this.scheduledExecutorService);
        TestingLogicalSlotBuilder slotBuilder = new TestingLogicalSlotBuilder();
        for (ExecutionJobVertex ejv : this.executionGraph.getVerticesTopologically()) {
            for (ExecutionVertex ev : ejv.getTaskVertices()) {
                TestingLogicalSlot slot = slotBuilder.createTestingLogicalSlot();
                Execution execution = ev.getCurrentExecutionAttempt();
                execution.registerProducedPartitions(slot.getTaskManagerLocation()).get();
                if (execution.tryAssignResource((LogicalSlot)slot)) continue;
                throw new RuntimeException("Error when assigning slot to execution.");
            }
        }
    }
}

