/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.resourcemanager.active.ResourceEventHandler;
import org.apache.flink.util.Preconditions;

public class TestingResourceEventHandler<WorkerType extends ResourceIDRetrievable>
implements ResourceEventHandler<WorkerType> {
    private final Consumer<Collection<WorkerType>> onPreviousAttemptWorkersRecoveredConsumer;
    private final BiConsumer<ResourceID, String> onWorkerTerminatedConsumer;
    private final Consumer<Throwable> onErrorConsumer;

    private TestingResourceEventHandler(Consumer<Collection<WorkerType>> onPreviousAttemptWorkersRecoveredConsumer, BiConsumer<ResourceID, String> onWorkerTerminatedConsumer, Consumer<Throwable> onErrorConsumer) {
        this.onPreviousAttemptWorkersRecoveredConsumer = onPreviousAttemptWorkersRecoveredConsumer;
        this.onWorkerTerminatedConsumer = onWorkerTerminatedConsumer;
        this.onErrorConsumer = onErrorConsumer;
    }

    public void onPreviousAttemptWorkersRecovered(Collection<WorkerType> recoveredWorkers) {
        this.onPreviousAttemptWorkersRecoveredConsumer.accept(recoveredWorkers);
    }

    public void onWorkerTerminated(ResourceID resourceId, String diagnostics) {
        this.onWorkerTerminatedConsumer.accept(resourceId, diagnostics);
    }

    public void onError(Throwable exception) {
        this.onErrorConsumer.accept(exception);
    }

    public static <WorkerType extends ResourceIDRetrievable> Builder<WorkerType> builder() {
        return new Builder();
    }

    public static class Builder<WorkerType extends ResourceIDRetrievable> {
        private Consumer<Collection<WorkerType>> onPreviousAttemptWorkersRecoveredConsumer = ignore -> {};
        private BiConsumer<ResourceID, String> onWorkerTerminatedConsumer = (ignore1, ignore2) -> {};
        private Consumer<Throwable> onErrorConsumer = ignore -> {};

        private Builder() {
        }

        public Builder<WorkerType> setOnPreviousAttemptWorkersRecoveredConsumer(Consumer<Collection<WorkerType>> onPreviousAttemptWorkersRecoveredConsumer) {
            this.onPreviousAttemptWorkersRecoveredConsumer = (Consumer)Preconditions.checkNotNull(onPreviousAttemptWorkersRecoveredConsumer);
            return this;
        }

        public Builder<WorkerType> setOnWorkerTerminatedConsumer(BiConsumer<ResourceID, String> onWorkerTerminatedConsumer) {
            this.onWorkerTerminatedConsumer = (BiConsumer)Preconditions.checkNotNull(onWorkerTerminatedConsumer);
            return this;
        }

        public Builder<WorkerType> setOnErrorConsumer(Consumer<Throwable> onErrorConsumer) {
            this.onErrorConsumer = (Consumer)Preconditions.checkNotNull(onErrorConsumer);
            return this;
        }

        public TestingResourceEventHandler<WorkerType> build() {
            return new TestingResourceEventHandler<WorkerType>(this.onPreviousAttemptWorkersRecoveredConsumer, this.onWorkerTerminatedConsumer, this.onErrorConsumer);
        }
    }
}

