/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.hash.InPlaceMutableHashTable;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.runtime.operators.testutils.UniformIntPairGenerator;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

class HashTablePerformanceComparison {
    private static final int PAGE_SIZE = 16384;
    private final int NUM_PAIRS = 20000000;
    private final int SIZE = 36;
    private final TypeSerializer<IntPair> serializer = new IntPairSerializer();
    private final TypeComparator<IntPair> comparator = new IntPairComparator();
    private final TypePairComparator<IntPair, IntPair> pairComparator = new IntPairPairComparator();

    HashTablePerformanceComparison() {
    }

    @Test
    void testCompactingHashMapPerformance() {
        try {
            int NUM_MEM_PAGES = 43945;
            UniformIntPairGenerator buildInput = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator probeTester = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updater = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updateTester = new UniformIntPairGenerator(20000000, 1, false);
            long first = System.currentTimeMillis();
            System.out.println("Creating and filling CompactingHashMap...");
            long start = System.currentTimeMillis();
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, HashTablePerformanceComparison.getMemory(43945, 16384));
            table.open();
            IntPair target = new IntPair();
            while (buildInput.next(target) != null) {
                table.insert((Object)target);
            }
            long end = System.currentTimeMillis();
            System.out.println("HashMap ready. Time: " + (end - start) + " ms");
            System.out.println("Starting first probing run...");
            start = System.currentTimeMillis();
            AbstractHashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair temp = new IntPair();
            while (probeTester.next(target) != null) {
                Assertions.assertThat((Object)((IntPair)prober.getMatchFor((Object)target, (Object)temp))).isNotNull();
                Assertions.assertThat((int)target.getValue()).isEqualTo(temp.getValue());
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            System.out.println("Starting update...");
            start = System.currentTimeMillis();
            while (updater.next(target) != null) {
                target.setValue(target.getValue() + 1);
                table.insertOrReplaceRecord((Object)target);
            }
            end = System.currentTimeMillis();
            System.out.println("Update done. Time: " + (end - start) + " ms");
            System.out.println("Starting second probing run...");
            start = System.currentTimeMillis();
            while (updateTester.next(target) != null) {
                Assertions.assertThat((Object)((IntPair)prober.getMatchFor((Object)target, (Object)temp))).isNotNull();
                Assertions.assertThat((int)(target.getValue() + 1)).isEqualTo(temp.getValue());
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            table.close();
            end = System.currentTimeMillis();
            System.out.println("Overall time: " + (end - first) + " ms");
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(43945);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    void testMutableHashMapPerformance() {
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            MutableHashTable.HashBucketIterator iter;
            int NUM_MEM_PAGES = 43945;
            UniformIntPairGenerator buildInput = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator probeInput = new UniformIntPairGenerator(0, 1, false);
            UniformIntPairGenerator probeTester = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updater = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updateTester = new UniformIntPairGenerator(20000000, 1, false);
            long first = System.currentTimeMillis();
            System.out.println("Creating and filling MutableHashMap...");
            long start = System.currentTimeMillis();
            MutableHashTable table = new MutableHashTable(this.serializer, this.serializer, this.comparator, this.comparator, this.pairComparator, HashTablePerformanceComparison.getMemory(43945, 16384), (IOManager)ioManager);
            table.open((MutableObjectIterator)buildInput, (MutableObjectIterator)probeInput);
            long end = System.currentTimeMillis();
            System.out.println("HashMap ready. Time: " + (end - start) + " ms");
            System.out.println("Starting first probing run...");
            start = System.currentTimeMillis();
            IntPair compare = new IntPair();
            IntPair target = new IntPair();
            while (probeTester.next(compare) != null) {
                iter = table.getMatchesFor((Object)compare);
                iter.next((Object)target);
                Assertions.assertThat((int)target.getKey()).isEqualTo(compare.getKey());
                Assertions.assertThat((int)target.getValue()).isEqualTo(compare.getValue());
                Assertions.assertThat((Object)((IntPair)iter.next((Object)target))).isNull();
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            System.out.println("Starting update...");
            start = System.currentTimeMillis();
            while (updater.next(compare) != null) {
                compare.setValue(compare.getValue() + 1);
                iter = table.getMatchesFor((Object)compare);
                iter.next((Object)target);
                iter.writeBack((Object)compare);
            }
            end = System.currentTimeMillis();
            System.out.println("Update done. Time: " + (end - start) + " ms");
            System.out.println("Starting second probing run...");
            start = System.currentTimeMillis();
            while (updateTester.next(compare) != null) {
                compare.setValue(compare.getValue() + 1);
                iter = table.getMatchesFor((Object)compare);
                iter.next((Object)target);
                Assertions.assertThat((int)target.getKey()).isEqualTo(compare.getKey());
                Assertions.assertThat((int)target.getValue()).isEqualTo(compare.getValue());
                Assertions.assertThat((Object)((IntPair)iter.next((Object)target))).isNull();
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            table.close();
            end = System.currentTimeMillis();
            System.out.println("Overall time: " + (end - first) + " ms");
            ((ListAssert)Assertions.assertThat((List)table.getFreedMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(43945);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    void testInPlaceMutableHashTablePerformance() {
        try {
            int NUM_MEM_PAGES = 43945;
            UniformIntPairGenerator buildInput = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator probeTester = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updater = new UniformIntPairGenerator(20000000, 1, false);
            UniformIntPairGenerator updateTester = new UniformIntPairGenerator(20000000, 1, false);
            long first = System.currentTimeMillis();
            System.out.println("Creating and filling InPlaceMutableHashTable...");
            long start = System.currentTimeMillis();
            InPlaceMutableHashTable table = new InPlaceMutableHashTable(this.serializer, this.comparator, HashTablePerformanceComparison.getMemory(43945, 16384));
            table.open();
            IntPair target = new IntPair();
            while (buildInput.next(target) != null) {
                table.insert((Object)target);
            }
            long end = System.currentTimeMillis();
            System.out.println("HashMap ready. Time: " + (end - start) + " ms");
            System.out.println("Starting first probing run...");
            start = System.currentTimeMillis();
            InPlaceMutableHashTable.HashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair temp = new IntPair();
            while (probeTester.next(target) != null) {
                Assertions.assertThat((Object)((IntPair)prober.getMatchFor((Object)target, (Object)temp))).isNotNull();
                Assertions.assertThat((int)temp.getValue()).isEqualTo(target.getValue());
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            System.out.println("Starting update...");
            start = System.currentTimeMillis();
            while (updater.next(target) != null) {
                target.setValue(target.getValue() + 1);
                table.insertOrReplaceRecord((Object)target);
            }
            end = System.currentTimeMillis();
            System.out.println("Update done. Time: " + (end - start) + " ms");
            System.out.println("Starting second probing run...");
            start = System.currentTimeMillis();
            while (updateTester.next(target) != null) {
                Assertions.assertThat((Object)((IntPair)prober.getMatchFor((Object)target, (Object)temp))).isNotNull();
                Assertions.assertThat((int)(target.getValue() + 1)).isEqualTo(temp.getValue());
            }
            end = System.currentTimeMillis();
            System.out.println("Probing done. Time: " + (end - start) + " ms");
            table.close();
            end = System.currentTimeMillis();
            System.out.println("Overall time: " + (end - first) + " ms");
            ((ListAssert)Assertions.assertThat((List)table.getFreeMemory()).withFailMessage("Memory lost", new Object[0])).hasSize(43945);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("Error: " + e.getMessage()));
        }
    }

    private static List<MemorySegment> getMemory(int numPages, int pageSize) {
        ArrayList<MemorySegment> memory = new ArrayList<MemorySegment>();
        for (int i = 0; i < numPages; ++i) {
            memory.add(MemorySegmentFactory.allocateUnpooledSegment((int)pageSize));
        }
        return memory;
    }
}

