/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.AbstractByteBufTest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NetworkBufferTest
extends AbstractByteBufTest {
    private static final int MAX_CAPACITY_UPPER_BOUND = 0x4000000;
    private static final NettyBufferPool NETTY_BUFFER_POOL = new NettyBufferPool(1);

    NetworkBufferTest() {
    }

    protected NetworkBuffer newBuffer(int length, int maxCapacity) {
        return NetworkBufferTest.newBuffer(length, maxCapacity, false);
    }

    private static NetworkBuffer newBuffer(int length, int maxCapacity, boolean isBuffer) {
        return NetworkBufferTest.newBuffer(length, maxCapacity, isBuffer, FreeingBufferRecycler.INSTANCE);
    }

    private static NetworkBuffer newBuffer(int length, int maxCapacity, boolean isBuffer, BufferRecycler recycler) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)Math.min(maxCapacity, 0x4000000));
        Buffer.DataType dataType = isBuffer ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
        NetworkBuffer buffer = new NetworkBuffer(segment, recycler, dataType);
        buffer.capacity(length);
        buffer.setAllocator((ByteBufAllocator)NETTY_BUFFER_POOL);
        Assertions.assertThat((Object)buffer.order()).isSameAs((Object)ByteOrder.BIG_ENDIAN);
        Assertions.assertThat((int)buffer.readerIndex()).isZero();
        Assertions.assertThat((int)buffer.writerIndex()).isZero();
        return buffer;
    }

    @Test
    void testDataBufferIsBuffer() {
        Assertions.assertThat((boolean)NetworkBufferTest.newBuffer(1024, 1024, true).isBuffer()).isTrue();
    }

    @Test
    void testEventBufferIsBuffer() {
        Assertions.assertThat((boolean)NetworkBufferTest.newBuffer(1024, 1024, false).isBuffer()).isFalse();
    }

    @Test
    void testDataBufferTagAsEvent() {
        NetworkBufferTest.testTagAsEvent(true);
    }

    @Test
    void testEventBufferTagAsEvent() {
        NetworkBufferTest.testTagAsEvent(false);
    }

    private static void testTagAsEvent(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setDataType(Buffer.DataType.EVENT_BUFFER);
        Assertions.assertThat((boolean)buffer.isBuffer()).isFalse();
    }

    @Test
    void testDataBufferGetMemorySegment() {
        NetworkBufferTest.testGetMemorySegment(true);
    }

    @Test
    void testEventBufferGetMemorySegment() {
        NetworkBufferTest.testGetMemorySegment(false);
    }

    private static void testGetMemorySegment(boolean isBuffer) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        Buffer.DataType dataType = isBuffer ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
        NetworkBuffer buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, dataType);
        Assertions.assertThat((Object)buffer.getMemorySegment()).isSameAs((Object)segment);
    }

    @Test
    void testDataBufferGetRecycler() {
        NetworkBufferTest.testGetRecycler(true);
    }

    @Test
    void testEventBufferGetRecycler() {
        NetworkBufferTest.testGetRecycler(false);
    }

    private static void testGetRecycler(boolean isBuffer) {
        BufferRecycler recycler = MemorySegment::free;
        NetworkBuffer dataBuffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer, recycler);
        Assertions.assertThat((Object)dataBuffer.getRecycler()).isSameAs((Object)recycler);
    }

    @Test
    void testDataBufferRecycleBuffer() {
        NetworkBufferTest.testRecycleBuffer(true);
    }

    @Test
    void testEventBufferRecycleBuffer() {
        NetworkBufferTest.testRecycleBuffer(false);
    }

    private static void testRecycleBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assertions.assertThat((boolean)buffer.isRecycled()).isFalse();
        buffer.recycleBuffer();
        Assertions.assertThat((boolean)buffer.isRecycled()).isTrue();
        Assertions.assertThat((int)buffer.refCnt()).isZero();
    }

    @Test
    void testDataBufferRetainBuffer() {
        NetworkBufferTest.testRetainBuffer(true);
    }

    @Test
    void testEventBufferRetainBuffer() {
        NetworkBufferTest.testRetainBuffer(false);
    }

    private static void testRetainBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assertions.assertThat((boolean)buffer.isRecycled()).isFalse();
        buffer.retainBuffer();
        Assertions.assertThat((boolean)buffer.isRecycled()).isFalse();
        Assertions.assertThat((int)buffer.refCnt()).isEqualTo(2);
    }

    @Test
    void testDataBufferCreateSlice1() {
        NetworkBufferTest.testCreateSlice1(true);
    }

    @Test
    void testEventBufferCreateSlice1() {
        NetworkBufferTest.testCreateSlice1(false);
    }

    private static void testCreateSlice1(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setSize(10);
        ReadOnlySlicedNetworkBuffer slice = buffer.readOnlySlice();
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getSize()).isEqualTo(10);
        Assertions.assertThat((Comparable)slice.unwrap().unwrap()).isSameAs((Object)buffer);
        buffer.setSize(8);
        buffer.setReaderIndex(2);
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getSize()).isEqualTo(10);
    }

    @Test
    void testDataBufferCreateSlice2() {
        NetworkBufferTest.testCreateSlice2(true);
    }

    @Test
    void testEventBufferCreateSlice2() {
        NetworkBufferTest.testCreateSlice2(false);
    }

    private static void testCreateSlice2(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setSize(2);
        ReadOnlySlicedNetworkBuffer slice = buffer.readOnlySlice(1, 10);
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getSize()).isEqualTo(10);
        Assertions.assertThat((Comparable)slice.unwrap().unwrap()).isSameAs((Object)buffer);
        buffer.setSize(8);
        buffer.setReaderIndex(2);
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getSize()).isEqualTo(10);
    }

    @Test
    void testDataBufferGetMaxCapacity() {
        NetworkBufferTest.testGetMaxCapacity(true);
    }

    @Test
    void testEventBufferGetMaxCapacity() {
        NetworkBufferTest.testGetMaxCapacity(false);
    }

    private static void testGetMaxCapacity(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(100, 1024, isBuffer);
        Assertions.assertThat((int)buffer.getMaxCapacity()).isEqualTo(1024);
        MemorySegment segment = buffer.getMemorySegment();
        Assertions.assertThat((int)segment.size()).isEqualTo(buffer.getMaxCapacity()).isEqualTo(buffer.maxCapacity());
    }

    @Test
    void testDataBufferGetSetReaderIndex() {
        NetworkBufferTest.testGetSetReaderIndex(true);
    }

    @Test
    void testEventBufferGetSetReaderIndex() {
        NetworkBufferTest.testGetSetReaderIndex(false);
    }

    private static void testGetSetReaderIndex(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(100, 1024, isBuffer);
        Assertions.assertThat((int)buffer.getReaderIndex()).isZero();
        buffer.setSize(100);
        Assertions.assertThat((int)buffer.getReaderIndex()).isZero();
        buffer.setReaderIndex(1);
        Assertions.assertThat((int)buffer.getReaderIndex()).isOne();
    }

    @Test
    void testDataBufferSetGetSize() {
        NetworkBufferTest.testSetGetSize(true);
    }

    @Test
    void testEventBufferSetGetSize() {
        NetworkBufferTest.testSetGetSize(false);
    }

    private static void testSetGetSize(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assertions.assertThat((int)buffer.getSize()).isZero();
        Assertions.assertThat((int)buffer.writerIndex()).isEqualTo(buffer.getSize());
        Assertions.assertThat((int)buffer.readerIndex()).isZero();
        buffer.setSize(10);
        Assertions.assertThat((int)buffer.getSize()).isEqualTo(10);
        Assertions.assertThat((int)buffer.writerIndex()).isEqualTo(buffer.getSize());
        Assertions.assertThat((int)buffer.readerIndex()).isZero();
    }

    @Test
    void testDataBufferReadableBytes() {
        NetworkBufferTest.testReadableBytes(true);
    }

    @Test
    void testEventBufferReadableBytes() {
        NetworkBufferTest.testReadableBytes(false);
    }

    private static void testReadableBytes(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assertions.assertThat((int)buffer.readableBytes()).isZero();
        buffer.setSize(10);
        Assertions.assertThat((int)buffer.readableBytes()).isEqualTo(10);
        buffer.setReaderIndex(2);
        Assertions.assertThat((int)buffer.readableBytes()).isEqualTo(8);
        buffer.setReaderIndex(10);
        Assertions.assertThat((int)buffer.readableBytes()).isZero();
    }

    @Test
    void testDataBufferGetNioBufferReadable() {
        this.testGetNioBufferReadable(true);
    }

    @Test
    void testEventBufferGetNioBufferReadable() {
        this.testGetNioBufferReadable(false);
    }

    private void testGetNioBufferReadable(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        ByteBuffer byteBuffer = buffer.getNioBufferReadable();
        Assertions.assertThat((boolean)byteBuffer.isReadOnly()).isFalse();
        Assertions.assertThat((int)byteBuffer.remaining()).isZero();
        Assertions.assertThat((int)byteBuffer.limit()).isZero();
        Assertions.assertThat((int)byteBuffer.capacity()).isZero();
        buffer.setSize(10);
        Assertions.assertThat((int)byteBuffer.remaining()).isZero();
        Assertions.assertThat((int)byteBuffer.limit()).isZero();
        Assertions.assertThat((int)byteBuffer.capacity()).isZero();
        byteBuffer = buffer.getNioBufferReadable();
        Assertions.assertThat((boolean)byteBuffer.isReadOnly()).isFalse();
        Assertions.assertThat((int)byteBuffer.remaining()).isEqualTo(10);
        Assertions.assertThat((int)byteBuffer.limit()).isEqualTo(10);
        Assertions.assertThat((int)byteBuffer.capacity()).isEqualTo(10);
        byteBuffer.position(1);
        Assertions.assertThat((int)buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)buffer.getSize()).isEqualTo(10);
    }

    @Test
    void testGetNioBufferReadableThreadSafe() {
        NetworkBuffer buffer = this.newBuffer(1024, 1024);
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)buffer);
    }

    static void testGetNioBufferReadableThreadSafe(Buffer buffer) {
        ByteBuffer buf1 = buffer.getNioBufferReadable();
        ByteBuffer buf2 = buffer.getNioBufferReadable();
        Assertions.assertThat((Comparable)buf1).isNotNull();
        Assertions.assertThat((Comparable)buf2).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buf1).withFailMessage("Repeated call to getNioBuffer() returns the same nio buffer", new Object[0])).isNotSameAs((Object)buf2);
    }

    @Test
    void testDataBufferGetNioBuffer() {
        this.testGetNioBuffer(true);
    }

    @Test
    void testEventBufferGetNioBuffer() {
        this.testGetNioBuffer(false);
    }

    private void testGetNioBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        ByteBuffer byteBuffer = buffer.getNioBuffer(1, 1);
        Assertions.assertThat((boolean)byteBuffer.isReadOnly()).isFalse();
        Assertions.assertThat((int)byteBuffer.remaining()).isOne();
        Assertions.assertThat((int)byteBuffer.limit()).isOne();
        Assertions.assertThat((int)byteBuffer.capacity()).isOne();
        buffer.setSize(10);
        Assertions.assertThat((int)byteBuffer.remaining()).isOne();
        Assertions.assertThat((int)byteBuffer.limit()).isOne();
        Assertions.assertThat((int)byteBuffer.capacity()).isOne();
        byteBuffer = buffer.getNioBuffer(1, 2);
        Assertions.assertThat((boolean)byteBuffer.isReadOnly()).isFalse();
        Assertions.assertThat((int)byteBuffer.remaining()).isEqualTo(2);
        Assertions.assertThat((int)byteBuffer.limit()).isEqualTo(2);
        Assertions.assertThat((int)byteBuffer.capacity()).isEqualTo(2);
        byteBuffer.position(1);
        Assertions.assertThat((int)buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)buffer.getSize()).isEqualTo(10);
    }

    @Test
    void testGetNioBufferThreadSafe() {
        NetworkBuffer buffer = this.newBuffer(1024, 1024);
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)buffer, 10);
    }

    static void testGetNioBufferThreadSafe(Buffer buffer, int length) {
        ByteBuffer buf1 = buffer.getNioBuffer(0, length);
        ByteBuffer buf2 = buffer.getNioBuffer(0, length);
        Assertions.assertThat((Comparable)buf1).isNotNull();
        Assertions.assertThat((Comparable)buf2).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buf1).withFailMessage("Repeated call to getNioBuffer(int, int) returns the same nio buffer", new Object[0])).isNotSameAs((Object)buf2);
    }

    @Test
    void testDataBufferSetAllocator() {
        this.testSetAllocator(true);
    }

    @Test
    void testEventBufferSetAllocator() {
        this.testSetAllocator(false);
    }

    private void testSetAllocator(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        NettyBufferPool allocator = new NettyBufferPool(1);
        buffer.setAllocator((ByteBufAllocator)allocator);
        Assertions.assertThat((Object)buffer.alloc()).isSameAs((Object)allocator);
    }
}

