/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.WrappingFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.CoGroupedStreams;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Collector;

@Public
public class JoinedStreams<T1, T2> {
    private final DataStream<T1> input1;
    private final DataStream<T2> input2;

    public JoinedStreams(DataStream<T1> input1, DataStream<T2> input2) {
        this.input1 = Objects.requireNonNull(input1);
        this.input2 = Objects.requireNonNull(input2);
    }

    public <KEY> Where<KEY> where(KeySelector<T1, KEY> keySelector) {
        Objects.requireNonNull(keySelector);
        TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, this.input1.getType());
        return this.where(keySelector, keyType);
    }

    public <KEY> Where<KEY> where(KeySelector<T1, KEY> keySelector, TypeInformation<KEY> keyType) {
        Objects.requireNonNull(keySelector);
        Objects.requireNonNull(keyType);
        return new Where<KEY>(this.input1.clean(keySelector), keyType);
    }

    private static class FlatJoinCoGroupFunction<T1, T2, T>
    extends WrappingFunction<FlatJoinFunction<T1, T2, T>>
    implements CoGroupFunction<T1, T2, T> {
        private static final long serialVersionUID = 1L;

        public FlatJoinCoGroupFunction(FlatJoinFunction<T1, T2, T> wrappedFunction) {
            super(wrappedFunction);
        }

        public void coGroup(Iterable<T1> first, Iterable<T2> second, Collector<T> out) throws Exception {
            for (T1 val1 : first) {
                for (T2 val2 : second) {
                    ((FlatJoinFunction)this.wrappedFunction).join(val1, val2, out);
                }
            }
        }
    }

    private static class JoinCoGroupFunction<T1, T2, T>
    extends WrappingFunction<JoinFunction<T1, T2, T>>
    implements CoGroupFunction<T1, T2, T> {
        private static final long serialVersionUID = 1L;

        public JoinCoGroupFunction(JoinFunction<T1, T2, T> wrappedFunction) {
            super(wrappedFunction);
        }

        public void coGroup(Iterable<T1> first, Iterable<T2> second, Collector<T> out) throws Exception {
            for (T1 val1 : first) {
                for (T2 val2 : second) {
                    out.collect(((JoinFunction)this.wrappedFunction).join(val1, val2));
                }
            }
        }
    }

    @Public
    public static class WithWindow<T1, T2, KEY, W extends Window> {
        private final DataStream<T1> input1;
        private final DataStream<T2> input2;
        private final KeySelector<T1, KEY> keySelector1;
        private final KeySelector<T2, KEY> keySelector2;
        private final TypeInformation<KEY> keyType;
        private final WindowAssigner<? super CoGroupedStreams.TaggedUnion<T1, T2>, W> windowAssigner;
        private final Trigger<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> trigger;
        private final Evictor<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> evictor;
        @Nullable
        private final Duration allowedLateness;
        private CoGroupedStreams.WithWindow<T1, T2, KEY, W> coGroupedWindowedStream;

        @PublicEvolving
        protected WithWindow(DataStream<T1> input1, DataStream<T2> input2, KeySelector<T1, KEY> keySelector1, KeySelector<T2, KEY> keySelector2, TypeInformation<KEY> keyType, WindowAssigner<? super CoGroupedStreams.TaggedUnion<T1, T2>, W> windowAssigner, Trigger<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> trigger, Evictor<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> evictor, @Nullable Duration allowedLateness) {
            this.input1 = Objects.requireNonNull(input1);
            this.input2 = Objects.requireNonNull(input2);
            this.keySelector1 = Objects.requireNonNull(keySelector1);
            this.keySelector2 = Objects.requireNonNull(keySelector2);
            this.keyType = Objects.requireNonNull(keyType);
            this.windowAssigner = Objects.requireNonNull(windowAssigner);
            this.trigger = trigger;
            this.evictor = evictor;
            this.allowedLateness = allowedLateness;
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> trigger(Trigger<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> newTrigger) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, newTrigger, this.evictor, this.allowedLateness);
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> evictor(Evictor<? super CoGroupedStreams.TaggedUnion<T1, T2>, ? super W> newEvictor) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, this.trigger, newEvictor, this.allowedLateness);
        }

        @PublicEvolving
        public WithWindow<T1, T2, KEY, W> allowedLateness(@Nullable Duration newLateness) {
            return new WithWindow<T1, T2, KEY, W>(this.input1, this.input2, this.keySelector1, this.keySelector2, this.keyType, this.windowAssigner, this.trigger, this.evictor, newLateness);
        }

        public <T> SingleOutputStreamOperator<T> apply(JoinFunction<T1, T2, T> function) {
            TypeInformation resultType = TypeExtractor.getBinaryOperatorReturnType(function, JoinFunction.class, (int)0, (int)1, (int)2, (int[])TypeExtractor.NO_INDEX, this.input1.getType(), this.input2.getType(), (String)"Join", (boolean)false);
            return this.apply(function, resultType);
        }

        public <T> SingleOutputStreamOperator<T> apply(FlatJoinFunction<T1, T2, T> function, TypeInformation<T> resultType) {
            function = this.input1.getExecutionEnvironment().clean(function);
            this.coGroupedWindowedStream = this.input1.coGroup(this.input2).where(this.keySelector1).equalTo(this.keySelector2).window(this.windowAssigner).trigger(this.trigger).evictor(this.evictor).allowedLateness(this.allowedLateness);
            return this.coGroupedWindowedStream.apply(new FlatJoinCoGroupFunction<T1, T2, T>(function), resultType);
        }

        public <T> SingleOutputStreamOperator<T> apply(FlatJoinFunction<T1, T2, T> function) {
            TypeInformation resultType = TypeExtractor.getBinaryOperatorReturnType(function, FlatJoinFunction.class, (int)0, (int)1, (int)2, (int[])new int[]{2, 0}, this.input1.getType(), this.input2.getType(), (String)"Join", (boolean)false);
            return this.apply(function, resultType);
        }

        public <T> SingleOutputStreamOperator<T> apply(JoinFunction<T1, T2, T> function, TypeInformation<T> resultType) {
            function = this.input1.getExecutionEnvironment().clean(function);
            this.coGroupedWindowedStream = this.input1.coGroup(this.input2).where(this.keySelector1).equalTo(this.keySelector2).window(this.windowAssigner).trigger(this.trigger).evictor(this.evictor).allowedLateness(this.allowedLateness);
            return this.coGroupedWindowedStream.apply(new JoinCoGroupFunction<T1, T2, T>(function), resultType);
        }

        @VisibleForTesting
        Optional<Duration> getAllowedLatenessDuration() {
            return Optional.ofNullable(this.allowedLateness);
        }

        @VisibleForTesting
        CoGroupedStreams.WithWindow<T1, T2, KEY, W> getCoGroupedWindowedStream() {
            return this.coGroupedWindowedStream;
        }
    }

    @Public
    public class Where<KEY> {
        private final KeySelector<T1, KEY> keySelector1;
        private final TypeInformation<KEY> keyType;

        Where(KeySelector<T1, KEY> keySelector1, TypeInformation<KEY> keyType) {
            this.keySelector1 = keySelector1;
            this.keyType = keyType;
        }

        public EqualTo equalTo(KeySelector<T2, KEY> keySelector) {
            Objects.requireNonNull(keySelector);
            TypeInformation otherKey = TypeExtractor.getKeySelectorTypes(keySelector, JoinedStreams.this.input2.getType());
            return this.equalTo(keySelector, otherKey);
        }

        public EqualTo equalTo(KeySelector<T2, KEY> keySelector, TypeInformation<KEY> keyType) {
            Objects.requireNonNull(keySelector);
            Objects.requireNonNull(keyType);
            if (!keyType.equals(this.keyType)) {
                throw new IllegalArgumentException("The keys for the two inputs are not equal: first key = " + this.keyType + " , second key = " + keyType);
            }
            return new EqualTo(JoinedStreams.this.input2.clean(keySelector));
        }

        @Public
        public class EqualTo {
            private final KeySelector<T2, KEY> keySelector2;

            EqualTo(KeySelector<T2, KEY> keySelector2) {
                this.keySelector2 = Objects.requireNonNull(keySelector2);
            }

            @PublicEvolving
            public <W extends Window> WithWindow<T1, T2, KEY, W> window(WindowAssigner<? super CoGroupedStreams.TaggedUnion<T1, T2>, W> assigner) {
                return new WithWindow(JoinedStreams.this.input1, JoinedStreams.this.input2, Where.this.keySelector1, this.keySelector2, Where.this.keyType, assigner, null, null, null);
            }
        }
    }
}

