/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.Objects;
import java.util.function.Function;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.util.Preconditions;

@Experimental
public class CommittableWithLineage<CommT>
implements CommittableMessage<CommT> {
    private final CommT committable;
    private final long checkpointId;
    private final int subtaskId;

    public CommittableWithLineage(CommT committable, long checkpointId, int subtaskId) {
        this.committable = Preconditions.checkNotNull(committable);
        this.checkpointId = checkpointId;
        this.subtaskId = subtaskId;
    }

    public CommT getCommittable() {
        return this.committable;
    }

    @Override
    public int getSubtaskId() {
        return this.subtaskId;
    }

    @Override
    public long getCheckpointIdOrEOI() {
        return this.checkpointId;
    }

    public <NewCommT> CommittableWithLineage<NewCommT> map(Function<CommT, NewCommT> mapper) {
        return new CommittableWithLineage<NewCommT>(mapper.apply(this.committable), this.checkpointId, this.subtaskId);
    }

    public CommittableWithLineage<CommT> withSubtaskId(int subtaskId) {
        return new CommittableWithLineage<CommT>(this.committable, this.checkpointId, subtaskId);
    }

    public String toString() {
        return "CommittableWithLineage{committable=" + this.committable + ", checkpointId=" + this.checkpointId + ", subtaskId=" + this.subtaskId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommittableWithLineage that = (CommittableWithLineage)o;
        return this.checkpointId == that.checkpointId && this.subtaskId == that.subtaskId && Objects.equals(this.committable, that.committable);
    }

    public int hashCode() {
        return Objects.hash(this.committable, this.checkpointId, this.subtaskId);
    }
}

