/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;

public class FileRegionWriteReadUtils {
    public static ByteBuffer allocateAndConfigureBuffer(int bufferSize) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public static void writeFixedSizeRegionToFile(FileChannel channel, ByteBuffer regionBuffer, FileDataIndexRegionHelper.Region region) throws IOException {
        regionBuffer.clear();
        regionBuffer.putInt(region.getFirstBufferIndex());
        regionBuffer.putInt(region.getNumBuffers());
        regionBuffer.putLong(region.getRegionStartOffset());
        regionBuffer.putLong(region.getRegionEndOffset());
        regionBuffer.flip();
        BufferReaderWriterUtil.writeBuffers(channel, regionBuffer.capacity(), regionBuffer);
    }

    public static ProducerMergedPartitionFileIndex.FixedSizeRegion readFixedSizeRegionFromFile(FileChannel channel, ByteBuffer regionBuffer, long fileOffset) throws IOException {
        regionBuffer.clear();
        BufferReaderWriterUtil.readByteBufferFully(channel, regionBuffer, fileOffset);
        regionBuffer.flip();
        int firstBufferIndex = regionBuffer.getInt();
        int numBuffers = regionBuffer.getInt();
        long firstBufferOffset = regionBuffer.getLong();
        long lastBufferEndOffset = regionBuffer.getLong();
        return new ProducerMergedPartitionFileIndex.FixedSizeRegion(firstBufferIndex, firstBufferOffset, lastBufferEndOffset, numBuffers);
    }
}

