/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.BatchCallbackRunner;
import org.apache.flink.runtime.asyncprocessing.ContextStateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.util.function.ThrowingRunnable;

public class StateFutureFactory<K> {
    private final AsyncExecutionController<K> asyncExecutionController;
    private final BatchCallbackRunner callbackRunner;
    private final StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler;

    StateFutureFactory(AsyncExecutionController<K> asyncExecutionController, BatchCallbackRunner callbackRunner, StateFutureImpl.AsyncFrameworkExceptionHandler exceptionHandler) {
        this.asyncExecutionController = asyncExecutionController;
        this.callbackRunner = callbackRunner;
        this.exceptionHandler = exceptionHandler;
    }

    public <OUT> InternalStateFuture<OUT> create(RecordContext<K> context) {
        return new ContextStateFutureImpl(runnable -> this.callbackRunner.submit((ThrowingRunnable<? extends Exception>)((ThrowingRunnable)() -> {
            this.asyncExecutionController.setCurrentContext(context);
            runnable.run();
        })), this.exceptionHandler, context);
    }
}

