/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.util.function.ThrowingRunnable;

public class BatchCallbackRunner {
    static final int DEFAULT_BATCH_SIZE = 3000;
    private final MailboxExecutor mailboxExecutor;
    private final int batchSize;
    private final ConcurrentLinkedDeque<ArrayList<ThrowingRunnable<? extends Exception>>> callbackQueue;
    private final Object activeBufferLock = new Object();
    @GuardedBy(value="activeBufferLock")
    private ArrayList<ThrowingRunnable<? extends Exception>> activeBuffer;
    private final AtomicInteger currentCallbacks = new AtomicInteger(0);
    private volatile boolean hasMail = false;
    private final Runnable newMailNotify;

    BatchCallbackRunner(MailboxExecutor mailboxExecutor, Runnable newMailNotify) {
        this.mailboxExecutor = mailboxExecutor;
        this.newMailNotify = newMailNotify;
        this.batchSize = 3000;
        this.callbackQueue = new ConcurrentLinkedDeque();
        this.activeBuffer = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(ThrowingRunnable<? extends Exception> task) {
        Object object = this.activeBufferLock;
        synchronized (object) {
            this.activeBuffer.add(task);
            if (this.activeBuffer.size() >= this.batchSize) {
                this.callbackQueue.offerLast(this.activeBuffer);
                this.activeBuffer = new ArrayList(this.batchSize);
            }
        }
        if (this.currentCallbacks.getAndIncrement() == 0) {
            this.insertMail(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertMail(boolean force, boolean notify) {
        BatchCallbackRunner batchCallbackRunner = this;
        synchronized (batchCallbackRunner) {
            if (force || !this.hasMail) {
                if (this.currentCallbacks.get() > 0) {
                    this.hasMail = true;
                    this.mailboxExecutor.execute(this::runBatch, "Batch running callback of state requests");
                    if (notify) {
                        this.notifyNewMail();
                    }
                } else {
                    this.hasMail = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBatch() throws Exception {
        ArrayList<ThrowingRunnable<? extends Exception>> batch = this.callbackQueue.poll();
        if (batch == null) {
            Iterator<ThrowingRunnable<? extends Exception>> iterator = this.activeBufferLock;
            synchronized (iterator) {
                if (!this.activeBuffer.isEmpty()) {
                    batch = this.activeBuffer;
                    this.activeBuffer = new ArrayList(this.batchSize);
                }
            }
        }
        if (batch != null) {
            for (ThrowingRunnable<? extends Exception> task : batch) {
                task.run();
            }
            this.currentCallbacks.addAndGet(-batch.size());
        }
        this.insertMail(true, false);
    }

    private void notifyNewMail() {
        if (this.newMailNotify != null) {
            this.newMailNotify.run();
        }
    }

    public boolean isHasMail() {
        return this.hasMail;
    }
}

