/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;

public class StateBackendUtils {
    public static void configureHashMapStateBackend(StreamExecutionEnvironment env) {
        env.configure((ReadableConfig)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)"hashmap"));
    }

    public static void configureRocksDBStateBackend(StreamExecutionEnvironment env) {
        env.configure((ReadableConfig)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)"rocksdb"));
    }

    public static void configureRocksDBStateBackend(StreamExecutionEnvironment env, boolean incrementalCheckpoints) {
        env.configure((ReadableConfig)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)"rocksdb").set(CheckpointingOptions.INCREMENTAL_CHECKPOINTS, (Object)incrementalCheckpoints));
    }

    public static void configureStateBackendWithFactory(StreamExecutionEnvironment env, String stateBackendFactory) {
        env.configure((ReadableConfig)new Configuration().set(StateBackendOptions.STATE_BACKEND, (Object)stateBackendFactory));
    }

    public static JobClient configureStateBackendAndExecuteAsync(StreamExecutionEnvironment env, StateBackend stateBackend) throws Exception {
        StreamGraph streamGraph = env.getStreamGraph();
        streamGraph.setStateBackend(stateBackend);
        return env.executeAsync(streamGraph);
    }

    public static JobGraph configureStateBackendAndGetJobGraph(StreamExecutionEnvironment env, StateBackend stateBackend) {
        StreamGraph streamGraph = env.getStreamGraph();
        streamGraph.setStateBackend(stateBackend);
        return streamGraph.getJobGraph();
    }

    public static JobGraph configureStateBackendAndGetJobGraph(StreamExecutionEnvironment env, StateBackend stateBackend, ClassLoader userClassLoader, JobID jobId) {
        StreamGraph streamGraph = env.getStreamGraph();
        streamGraph.setStateBackend(stateBackend);
        return streamGraph.getJobGraph(userClassLoader, jobId);
    }
}

