/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class StreamRecordTest {
    StreamRecordTest() {
    }

    @Test
    void testWithNoTimestamp() {
        StreamRecord record = new StreamRecord((Object)"test");
        Assertions.assertThat((boolean)record.isRecord()).isTrue();
        Assertions.assertThat((boolean)record.isWatermark()).isFalse();
        Assertions.assertThat((boolean)record.hasTimestamp()).isFalse();
        Assertions.assertThat((String)((String)record.getValue())).isEqualTo("test");
        Assertions.assertThat((long)record.getTimestamp()).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((String)record.toString()).isNotNull();
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)record).hasSameHashCodeAs((Object)new StreamRecord((Object)"test"))).isEqualTo((Object)new StreamRecord((Object)"test"))).isEqualTo((Object)record.asRecord());
        Assertions.assertThatThrownBy(() -> ((StreamRecord)record).asWatermark()).isInstanceOf(ClassCastException.class);
    }

    @Test
    void testWithTimestamp() {
        StreamRecord record = new StreamRecord((Object)"foo", 42L);
        Assertions.assertThat((boolean)record.isRecord()).isTrue();
        Assertions.assertThat((boolean)record.isWatermark()).isFalse();
        Assertions.assertThat((boolean)record.hasTimestamp()).isTrue();
        Assertions.assertThat((long)record.getTimestamp()).isEqualTo(42L);
        Assertions.assertThat((String)((String)record.getValue())).isEqualTo("foo");
        Assertions.assertThat((String)record.toString()).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)record).hasSameHashCodeAs((Object)new StreamRecord((Object)"foo", 42L))).doesNotHaveSameHashCodeAs((Object)new StreamRecord((Object)"foo"));
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)record).isEqualTo((Object)new StreamRecord((Object)"foo", 42L))).isNotEqualTo((Object)new StreamRecord((Object)"foo"))).isEqualTo((Object)record.asRecord());
        Assertions.assertThatThrownBy(() -> ((StreamRecord)record).asWatermark()).isInstanceOf(ClassCastException.class);
    }

    @Test
    void testAllowedTimestampRange() {
        Assertions.assertThat((long)new StreamRecord((Object)"test", 0L).getTimestamp()).isZero();
        Assertions.assertThat((long)new StreamRecord((Object)"test", -1L).getTimestamp()).isEqualTo(-1L);
        Assertions.assertThat((long)new StreamRecord((Object)"test", 1L).getTimestamp()).isOne();
        Assertions.assertThat((long)new StreamRecord((Object)"test", Long.MIN_VALUE).getTimestamp()).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((long)new StreamRecord((Object)"test", Long.MAX_VALUE).getTimestamp()).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    void testReplacePreservesTimestamp() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"o sole mio");
        StreamRecord newRecNoTimestamp = recNoTimestamp.replace((Object)17);
        Assertions.assertThat((boolean)newRecNoTimestamp.hasTimestamp()).isFalse();
        StreamRecord recWithTimestamp = new StreamRecord((Object)"la dolce vita", 99L);
        StreamRecord newRecWithTimestamp = recWithTimestamp.replace((Object)17);
        Assertions.assertThat((boolean)newRecWithTimestamp.hasTimestamp()).isTrue();
        Assertions.assertThat((long)newRecWithTimestamp.getTimestamp()).isEqualTo(99L);
    }

    @Test
    void testReplaceWithTimestampOverridesTimestamp() {
        StreamRecord record = new StreamRecord((Object)"la divina comedia");
        Assertions.assertThat((boolean)record.hasTimestamp()).isFalse();
        StreamRecord newRecord = record.replace((Object)3.14, 123L);
        Assertions.assertThat((boolean)newRecord.hasTimestamp()).isTrue();
        Assertions.assertThat((long)newRecord.getTimestamp()).isEqualTo(123L);
    }

    @Test
    void testCopy() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"test");
        StreamRecord recNoTimestampCopy = recNoTimestamp.copy((Object)"test");
        Assertions.assertThat((Object)recNoTimestampCopy).isEqualTo((Object)recNoTimestamp);
        StreamRecord recWithTimestamp = new StreamRecord((Object)"test", 99L);
        StreamRecord recWithTimestampCopy = recWithTimestamp.copy((Object)"test");
        Assertions.assertThat((Object)recWithTimestampCopy).isEqualTo((Object)recWithTimestamp);
    }

    @Test
    void testCopyTo() {
        StreamRecord recNoTimestamp = new StreamRecord((Object)"test");
        StreamRecord recNoTimestampCopy = new StreamRecord(null);
        recNoTimestamp.copyTo((Object)"test", recNoTimestampCopy);
        Assertions.assertThat((Object)recNoTimestampCopy).isEqualTo((Object)recNoTimestamp);
        StreamRecord recWithTimestamp = new StreamRecord((Object)"test", 99L);
        StreamRecord recWithTimestampCopy = new StreamRecord(null);
        recWithTimestamp.copyTo((Object)"test", recWithTimestampCopy);
        Assertions.assertThat((Object)recWithTimestampCopy).isEqualTo((Object)recWithTimestamp);
    }

    @Test
    void testSetAndEraseTimestamps() {
        StreamRecord rec = new StreamRecord((Object)"hello");
        Assertions.assertThat((boolean)rec.hasTimestamp()).isFalse();
        rec.setTimestamp(13456L);
        Assertions.assertThat((boolean)rec.hasTimestamp()).isTrue();
        Assertions.assertThat((long)rec.getTimestamp()).isEqualTo(13456L);
        rec.eraseTimestamp();
        Assertions.assertThat((boolean)rec.hasTimestamp()).isFalse();
    }
}

