/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.ConfigurationException;

public class TestRestServerEndpoint
extends RestServerEndpoint {
    private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers;

    public static Builder builder(Configuration configuration) {
        return new Builder(configuration);
    }

    private TestRestServerEndpoint(Configuration configuration, List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) throws IOException, ConfigurationException {
        super(configuration);
        this.handlers = handlers;
    }

    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> ignore) {
        return this.handlers;
    }

    protected void startInternal() {
    }

    public static class Builder {
        private final Configuration configuration;
        private final List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>();

        private Builder(Configuration configuration) {
            this.configuration = configuration;
        }

        public Builder withHandler(RestHandlerSpecification messageHeaders, ChannelInboundHandler handler) {
            this.handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)messageHeaders, (Object)handler));
            return this;
        }

        public Builder withHandler(AbstractRestHandler<?, ?, ?, ?> handler) {
            this.handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)handler.getMessageHeaders(), handler));
            return this;
        }

        public TestRestServerEndpoint build() throws IOException, ConfigurationException {
            return new TestRestServerEndpoint(this.configuration, this.handlers);
        }

        public TestRestServerEndpoint buildAndStart() throws Exception {
            TestRestServerEndpoint serverEndpoint = this.build();
            serverEndpoint.start();
            return serverEndpoint;
        }
    }
}

