/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.junit.jupiter.api.Test;

class MemoryManagerConcurrentModReleaseTest {
    MemoryManagerConcurrentModReleaseTest() {
    }

    @Test
    void testConcurrentModificationOnce() throws MemoryAllocationException {
        int numSegments = 10000;
        int segmentSize = 4096;
        MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(40960000L).setPageSize(4096).build();
        ListWithConcModExceptionOnFirstAccess segs = new ListWithConcModExceptionOnFirstAccess();
        memMan.allocatePages((Object)this, segs, 10000);
        memMan.release(segs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentModificationWhileReleasing() throws Exception {
        int numSegments = 10000;
        int segmentSize = 4096;
        MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(40960000L).setPageSize(4096).build();
        ArrayList<MemorySegment> segs = new ArrayList<MemorySegment>(10000);
        memMan.allocatePages((Object)this, segs, 10000);
        Modifier mod = new Modifier(segs);
        Thread modRunner = new Thread(mod);
        modRunner.start();
        Thread.sleep(500L);
        try {
            memMan.release(segs);
        }
        finally {
            mod.cancel();
        }
        modRunner.join();
    }

    private static class ConcFailingIterator<E>
    implements Iterator<E> {
        private ConcFailingIterator() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public E next() {
            throw new ConcurrentModificationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ListWithConcModExceptionOnFirstAccess<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -1623249699823349781L;
        private boolean returnedIterator;

        private ListWithConcModExceptionOnFirstAccess() {
        }

        @Override
        public Iterator<E> iterator() {
            if (this.returnedIterator) {
                return super.iterator();
            }
            this.returnedIterator = true;
            return new ConcFailingIterator();
        }
    }

    private static class Modifier
    implements Runnable {
        private final ArrayList<MemorySegment> toModify;
        private volatile boolean running = true;

        private Modifier(ArrayList<MemorySegment> toModify) {
            this.toModify = toModify;
        }

        public void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    MemorySegment seg = this.toModify.remove(0);
                    this.toModify.add(seg);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
        }
    }
}

