/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.TestingFileDataIndexRegion;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.BiFunctionWithException;

public class TestingFileDataIndexRegionHelper
implements FileDataIndexRegionHelper<TestingFileDataIndexRegion> {
    private final BiConsumerWithException<FileChannel, TestingFileDataIndexRegion, IOException> writeRegionToFileConsumer;
    private final BiFunctionWithException<FileChannel, Long, TestingFileDataIndexRegion, IOException> readRegionFromFileFunction;

    private TestingFileDataIndexRegionHelper(BiConsumerWithException<FileChannel, TestingFileDataIndexRegion, IOException> writeRegionToFileConsumer, BiFunctionWithException<FileChannel, Long, TestingFileDataIndexRegion, IOException> readRegionFromFileFunction) {
        this.writeRegionToFileConsumer = writeRegionToFileConsumer;
        this.readRegionFromFileFunction = readRegionFromFileFunction;
    }

    public void writeRegionToFile(FileChannel channel, TestingFileDataIndexRegion region) throws IOException {
        this.writeRegionToFileConsumer.accept((Object)channel, (Object)region);
    }

    public TestingFileDataIndexRegion readRegionFromFile(FileChannel channel, long fileOffset) throws IOException {
        return (TestingFileDataIndexRegion)this.readRegionFromFileFunction.apply((Object)channel, (Object)fileOffset);
    }

    public static class Builder {
        private BiConsumerWithException<FileChannel, TestingFileDataIndexRegion, IOException> writeRegionToFileConsumer = (fileChannel, testRegion) -> {};
        private BiFunctionWithException<FileChannel, Long, TestingFileDataIndexRegion, IOException> readRegionFromFileFunction = (fileChannel, fileOffset) -> null;

        public Builder setWriteRegionToFileConsumer(BiConsumerWithException<FileChannel, TestingFileDataIndexRegion, IOException> writeRegionToFileConsumer) {
            this.writeRegionToFileConsumer = writeRegionToFileConsumer;
            return this;
        }

        public Builder setReadRegionFromFileFunction(BiFunctionWithException<FileChannel, Long, TestingFileDataIndexRegion, IOException> readRegionFromFileFunction) {
            this.readRegionFromFileFunction = readRegionFromFileFunction;
            return this;
        }

        public TestingFileDataIndexRegionHelper build() {
            return new TestingFileDataIndexRegionHelper(this.writeRegionToFileConsumer, this.readRegionFromFileFunction);
        }
    }
}

