/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.DispatcherOperationCaches;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.dispatcher.runner.TestingDispatcherRunner;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerService;
import org.apache.flink.runtime.rest.ClosedRestService;
import org.apache.flink.runtime.rest.RestService;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DispatcherResourceManagerComponentTest
extends TestLogger {
    @Test
    public void unexpectedResourceManagerTermination_failsFatally() {
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setTerminationFuture(terminationFuture).build();
        this.createDispatcherResourceManagerComponent(fatalErrorHandler, resourceManagerService);
        FlinkException expectedException = new FlinkException("Expected test exception.");
        terminationFuture.completeExceptionally((Throwable)expectedException);
        Throwable error = fatalErrorHandler.getException();
        Assert.assertThat((Object)error, (Matcher)FlinkMatchers.containsCause((Throwable)expectedException));
    }

    private DispatcherResourceManagerComponent createDispatcherResourceManagerComponent(TestingFatalErrorHandler fatalErrorHandler, TestingResourceManagerService resourceManagerService) {
        return new DispatcherResourceManagerComponent((DispatcherRunner)TestingDispatcherRunner.newBuilder().build(), (ResourceManagerService)resourceManagerService, (LeaderRetrievalService)new SettableLeaderRetrievalService(), (LeaderRetrievalService)new SettableLeaderRetrievalService(), (RestService)ClosedRestService.INSTANCE, (FatalErrorHandler)fatalErrorHandler, new DispatcherOperationCaches());
    }

    @Test
    public void unexpectedResourceManagerTermination_ifNotRunning_doesNotFailFatally() {
        TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingResourceManagerService resourceManagerService = TestingResourceManagerService.newBuilder().setTerminationFuture(terminationFuture).withManualTerminationFutureCompletion().build();
        DispatcherResourceManagerComponent dispatcherResourceManagerComponent = this.createDispatcherResourceManagerComponent(fatalErrorHandler, resourceManagerService);
        dispatcherResourceManagerComponent.closeAsync();
        FlinkException expectedException = new FlinkException("Expected test exception.");
        terminationFuture.completeExceptionally((Throwable)expectedException);
        CompletableFuture<Throwable> errorFuture = fatalErrorHandler.getErrorFuture();
        Assert.assertThat(errorFuture, (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(10L)));
    }

    private static class TestingResourceManagerService
    implements ResourceManagerService {
        private final CompletableFuture<Void> terminationFuture;
        private final boolean completeTerminationFutureOnClose;

        private TestingResourceManagerService(CompletableFuture<Void> terminationFuture, boolean completeTerminationFutureOnClose) {
            this.terminationFuture = terminationFuture;
            this.completeTerminationFutureOnClose = completeTerminationFutureOnClose;
        }

        public void start() throws Exception {
        }

        public CompletableFuture<Void> getTerminationFuture() {
            return this.terminationFuture;
        }

        public CompletableFuture<Void> deregisterApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
            return FutureUtils.completedVoidFuture();
        }

        public CompletableFuture<Void> closeAsync() {
            if (this.completeTerminationFutureOnClose) {
                this.terminationFuture.complete(null);
            }
            return this.getTerminationFuture();
        }

        private static Builder newBuilder() {
            return new Builder();
        }

        private static class Builder {
            private CompletableFuture<Void> terminationFuture = new CompletableFuture();
            private boolean completeTerminationFutureOnClose = true;

            private Builder() {
            }

            private Builder setTerminationFuture(CompletableFuture<Void> terminationFuture) {
                this.terminationFuture = terminationFuture;
                return this;
            }

            private Builder withManualTerminationFutureCompletion() {
                this.completeTerminationFutureOnClose = false;
                return this;
            }

            private TestingResourceManagerService build() {
                return new TestingResourceManagerService(this.terminationFuture, this.completeTerminationFutureOnClose);
            }
        }
    }
}

