/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.dispatcher.cleanup.TestingRetryStrategies;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.webmonitor.retriever.impl.RpcGatewayRetriever;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class RpcGatewayRetrieverTest {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static TestingRpcService rpcService;

    RpcGatewayRetrieverTest() {
    }

    @BeforeAll
    static void setup() {
        rpcService = new TestingRpcService();
    }

    @AfterAll
    static void teardown() throws InterruptedException, ExecutionException {
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService[])new RpcService[]{rpcService});
            rpcService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRpcGatewayRetrieval() throws Exception {
        String expectedValue = "foobar";
        String expectedValue2 = "barfoo";
        UUID leaderSessionId = UUID.randomUUID();
        RpcGatewayRetriever gatewayRetriever = new RpcGatewayRetriever((RpcService)rpcService, DummyGateway.class, Function.identity(), TestingRetryStrategies.NO_RETRY_STRATEGY);
        SettableLeaderRetrievalService settableLeaderRetrievalService = new SettableLeaderRetrievalService();
        DummyRpcEndpoint dummyRpcEndpoint = new DummyRpcEndpoint(rpcService, "dummyRpcEndpoint1", "foobar");
        DummyRpcEndpoint dummyRpcEndpoint2 = new DummyRpcEndpoint(rpcService, "dummyRpcEndpoint2", "barfoo");
        rpcService.registerGateway(dummyRpcEndpoint.getAddress(), dummyRpcEndpoint.getSelfGateway(DummyGateway.class));
        rpcService.registerGateway(dummyRpcEndpoint2.getAddress(), dummyRpcEndpoint2.getSelfGateway(DummyGateway.class));
        try {
            dummyRpcEndpoint.start();
            dummyRpcEndpoint2.start();
            settableLeaderRetrievalService.start((LeaderRetrievalListener)gatewayRetriever);
            CompletableFuture gatewayFuture = gatewayRetriever.getFuture();
            Assertions.assertThat((CompletableFuture)gatewayFuture).isNotDone();
            settableLeaderRetrievalService.notifyListener(dummyRpcEndpoint.getAddress(), leaderSessionId);
            DummyGateway dummyGateway = (DummyGateway)gatewayFuture.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assertions.assertThat((String)dummyGateway.getAddress()).isEqualTo(dummyRpcEndpoint.getAddress());
            FlinkAssertions.assertThatFuture(dummyGateway.foobar(TIMEOUT)).eventuallySucceeds().isEqualTo((Object)"foobar");
            settableLeaderRetrievalService.notifyListener(dummyRpcEndpoint2.getAddress(), leaderSessionId);
            CompletableFuture gatewayFuture2 = gatewayRetriever.getFuture();
            DummyGateway dummyGateway2 = (DummyGateway)gatewayFuture2.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assertions.assertThat((String)dummyGateway2.getAddress()).isEqualTo(dummyRpcEndpoint2.getAddress());
            FlinkAssertions.assertThatFuture(dummyGateway2.foobar(TIMEOUT)).eventuallySucceeds().isEqualTo((Object)"barfoo");
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{dummyRpcEndpoint, dummyRpcEndpoint2});
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{dummyRpcEndpoint, dummyRpcEndpoint2});
    }

    static class DummyRpcEndpoint
    extends RpcEndpoint
    implements DummyGateway {
        private final String value;

        protected DummyRpcEndpoint(RpcService rpcService, String endpointId, String value) {
            super(rpcService, endpointId);
            this.value = value;
        }

        @Override
        public CompletableFuture<String> foobar(Time timeout) {
            return CompletableFuture.completedFuture(this.value);
        }

        public UUID getFencingToken() {
            return HighAvailabilityServices.DEFAULT_LEADER_ID;
        }
    }

    public static interface DummyGateway
    extends FencedRpcGateway<UUID> {
        public CompletableFuture<String> foobar(@RpcTimeout Time var1);
    }
}

