/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.shaded.curator5.org.apache.curator.framework.CuratorFramework;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ZooKeeperUtilsWriteLeaderInformationTest {
    private final ZooKeeperExtension zooKeeperExtension = new ZooKeeperExtension();
    @RegisterExtension
    private final EachCallbackWrapper<ZooKeeperExtension> eachWrapper = new EachCallbackWrapper((CustomExtension)this.zooKeeperExtension);

    ZooKeeperUtilsWriteLeaderInformationTest() {
    }

    @Test
    public void testWriteAndReadLeaderInformation() throws Exception {
        this.runWriteAndReadLeaderInformationTest(LeaderInformation.known((UUID)UUID.randomUUID(), (String)"barfoo"));
    }

    @Test
    public void testWriteAndReadEmptyLeaderInformation() throws Exception {
        this.runWriteAndReadLeaderInformationTest(LeaderInformation.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWriteAndReadLeaderInformationTest(LeaderInformation leaderInformation) throws Exception {
        String path = "/foobar";
        try (CuratorFrameworkWithUnhandledErrorListener curatorFramework = this.startCuratorFramework();){
            ZooKeeperUtils.writeLeaderInformationToZooKeeper((LeaderInformation)leaderInformation, (CuratorFramework)curatorFramework.asCuratorFramework(), () -> true, (String)"/foobar");
            LeaderInformation readLeaderInformation = ZooKeeperUtils.readLeaderInformation((byte[])((byte[])curatorFramework.asCuratorFramework().getData().forPath("/foobar")));
            Assertions.assertThat((Object)readLeaderInformation).isEqualTo((Object)leaderInformation);
        }
    }

    @Nonnull
    private CuratorFrameworkWithUnhandledErrorListener startCuratorFramework() {
        Configuration configuration = new Configuration();
        configuration.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)this.zooKeeperExtension.getConnectString());
        CuratorFrameworkWithUnhandledErrorListener curatorFramework = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
        return curatorFramework;
    }

    @Test
    public void testDeleteZNode() throws Exception {
        try (CuratorFrameworkWithUnhandledErrorListener curatorFramework = this.startCuratorFramework();){
            String path = "/foobar";
            curatorFramework.asCuratorFramework().create().forPath("/foobar", new byte[4]);
            curatorFramework.asCuratorFramework().create().forPath("/foobar/bar", new byte[4]);
            ZooKeeperUtils.deleteZNode((CuratorFramework)curatorFramework.asCuratorFramework(), (String)"/foobar");
            Assertions.assertThat((List)((List)curatorFramework.asCuratorFramework().getChildren().forPath("/"))).isEmpty();
        }
    }
}

