/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.BoundedFIFOQueue;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BoundedFIFOQueueTest {
    BoundedFIFOQueueTest() {
    }

    @Test
    void testConstructorFailing() {
        Assertions.assertThatThrownBy(() -> new BoundedFIFOQueue(-1)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testQueueWithMaxSize0() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(0);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
        testInstance.add((Object)1);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
    }

    @Test
    void testQueueWithMaxSize2() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(2);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
        testInstance.add((Object)1);
        Assertions.assertThat((Iterable)testInstance).contains((Object[])new Integer[]{1});
        testInstance.add((Object)2);
        Assertions.assertThat((Iterable)testInstance).contains((Object[])new Integer[]{1, 2});
        testInstance.add((Object)3);
        Assertions.assertThat((Iterable)testInstance).contains((Object[])new Integer[]{2, 3});
    }

    @Test
    void testAddNullHandling() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.add(null)).withFailMessage("A NullPointerException is expected to be thrown.", new Object[0])).isInstanceOf(NullPointerException.class);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
    }

    @Test
    void testSizeWithMaxSize0() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(0);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
        testInstance.add((Object)1);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
    }

    @Test
    void testSizeWithMaxSize2() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(2);
        Assertions.assertThat((Iterable)testInstance).isEmpty();
        testInstance.add((Object)5);
        Assertions.assertThat((Iterable)testInstance).hasSize(1);
        testInstance.add((Object)6);
        Assertions.assertThat((Iterable)testInstance).hasSize(2);
        testInstance.add((Object)7);
        Assertions.assertThat((Iterable)testInstance).hasSize(2);
    }
}

