/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateLatencyTrackOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LatencyTrackingStateConfigTest {
    LatencyTrackingStateConfigTest() {
    }

    @Test
    void testDefaultDisabledLatencyTrackingStateConfig() {
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isFalse();
    }

    @Test
    void testDefaultEnabledLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().setEnabled(true).setMetricGroup((MetricGroup)metricsGroup).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(((Integer)StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue()).intValue());
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo((long)((Integer)StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue()).intValue());
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isStateNameAsVariable()).isEqualTo(StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE.defaultValue());
    }

    @Test
    void testSetLatencyTrackingStateConfig() {
        UnregisteredMetricsGroup metricsGroup = new UnregisteredMetricsGroup();
        LatencyTrackingStateConfig latencyTrackingStateConfig = LatencyTrackingStateConfig.newBuilder().setMetricGroup((MetricGroup)metricsGroup).setEnabled(true).setSampleInterval(10).setHistorySize(500).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }

    @Test
    void testConfigureFromReadableConfig() {
        LatencyTrackingStateConfig.Builder builder = LatencyTrackingStateConfig.newBuilder();
        Configuration configuration = new Configuration();
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_ENABLED, (Object)true);
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL, (Object)10);
        configuration.set(StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE, (Object)500);
        LatencyTrackingStateConfig latencyTrackingStateConfig = builder.configure((ReadableConfig)configuration).setMetricGroup((MetricGroup)new UnregisteredMetricsGroup()).build();
        Assertions.assertThat((boolean)latencyTrackingStateConfig.isEnabled()).isTrue();
        Assertions.assertThat((int)latencyTrackingStateConfig.getSampleInterval()).isEqualTo(10);
        Assertions.assertThat((int)latencyTrackingStateConfig.getHistorySize()).isEqualTo(500);
    }
}

