/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.security.token.DelegationTokenReceiver;

public class ExceptionThrowingDelegationTokenReceiver
implements DelegationTokenReceiver {
    public static volatile ThreadLocal<Boolean> throwInInit = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Boolean> throwInUsage = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Boolean> constructed = ThreadLocal.withInitial(() -> Boolean.FALSE);
    public static volatile ThreadLocal<Integer> onNewTokensObtainedCallCount = ThreadLocal.withInitial(() -> 0);

    public static void reset() {
        throwInInit.set(false);
        throwInUsage.set(false);
        constructed.set(false);
        onNewTokensObtainedCallCount.set(0);
    }

    public ExceptionThrowingDelegationTokenReceiver() {
        constructed.set(true);
    }

    public String serviceName() {
        return "throw";
    }

    public void init(Configuration configuration) {
        if (throwInInit.get().booleanValue()) {
            throw new IllegalArgumentException();
        }
    }

    public void onNewTokensObtained(byte[] tokens) throws Exception {
        if (throwInUsage.get().booleanValue()) {
            throw new IllegalArgumentException();
        }
        onNewTokensObtainedCallCount.set(onNewTokensObtainedCallCount.get() + 1);
    }
}

