/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.RestoreMode;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.EmbeddedCompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.scheduler.SchedulerUtils;
import org.apache.flink.runtime.scheduler.SharedSlotTest;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.PlaceholderStreamStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryFactory;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulerUtilsTest {
    private static final Logger log = LoggerFactory.getLogger(SharedSlotTest.class);

    SchedulerUtilsTest() {
    }

    @Test
    void testSettingMaxNumberOfCheckpointsToRetain() throws Exception {
        int maxNumberOfCheckpointsToRetain = 10;
        Configuration jobManagerConfig = new Configuration();
        jobManagerConfig.set(CheckpointingOptions.MAX_RETAINED_CHECKPOINTS, (Object)10);
        CompletedCheckpointStore completedCheckpointStore = SchedulerUtils.createCompletedCheckpointStore((Configuration)jobManagerConfig, (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Executor)Executors.directExecutor(), (Logger)log, (JobID)new JobID(), (RestoreMode)RestoreMode.CLAIM);
        Assertions.assertThat((int)completedCheckpointStore.getMaxNumberOfRetainedCheckpoints()).isEqualTo(10);
    }

    @Test
    void testSharedStateRegistration() throws Exception {
        UUID backendId = UUID.randomUUID();
        String localPath = "k0";
        ByteStreamStateHandle handle = new ByteStreamStateHandle("h0", new byte[]{1, 2, 3});
        CheckpointRecoveryFactory recoveryFactory = this.buildRecoveryFactory(this.buildCheckpoint((KeyedStateHandle)this.buildIncrementalHandle(localPath, (StreamStateHandle)handle, backendId)));
        CompletedCheckpointStore checkpointStore = SchedulerUtils.createCompletedCheckpointStore((Configuration)new Configuration(), (CheckpointRecoveryFactory)recoveryFactory, (Executor)Executors.directExecutor(), (Logger)log, (JobID)new JobID(), (RestoreMode)RestoreMode.CLAIM);
        SharedStateRegistry sharedStateRegistry = checkpointStore.getSharedStateRegistry();
        IncrementalRemoteKeyedStateHandle newHandle = this.buildIncrementalHandle(localPath, (StreamStateHandle)new PlaceholderStreamStateHandle(handle.getStreamStateHandleID(), handle.getStateSize(), false), backendId);
        newHandle.registerSharedStates(sharedStateRegistry, 1L);
        Assertions.assertThat((Object)newHandle.getSharedState().stream().filter(e -> e.getLocalPath().equals(localPath)).findFirst().get().getHandle()).isEqualTo((Object)handle);
    }

    private CheckpointRecoveryFactory buildRecoveryFactory(final CompletedCheckpoint checkpoint) {
        return new CheckpointRecoveryFactory(){

            public CompletedCheckpointStore createRecoveredCompletedCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, SharedStateRegistryFactory sharedStateRegistryFactory, Executor ioExecutor, RestoreMode restoreMode) {
                List<CompletedCheckpoint> checkpoints = Collections.singletonList(checkpoint);
                return new EmbeddedCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, checkpoints, sharedStateRegistryFactory.create(ioExecutor, checkpoints, RestoreMode.DEFAULT));
            }

            public CheckpointIDCounter createCheckpointIDCounter(JobID jobId) {
                return new StandaloneCheckpointIDCounter();
            }
        };
    }

    private CompletedCheckpoint buildCheckpoint(KeyedStateHandle incremental) {
        OperatorID operatorID = new OperatorID();
        OperatorState operatorState = new OperatorState(operatorID, 1, 1);
        operatorState.putState(0, OperatorSubtaskState.builder().setManagedKeyedState(incremental).build());
        return new CompletedCheckpoint(new JobID(), 1L, 1L, 1L, Collections.singletonMap(operatorID, operatorState), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
    }

    private IncrementalRemoteKeyedStateHandle buildIncrementalHandle(String localPath, StreamStateHandle shared, UUID backendIdentifier) {
        ByteStreamStateHandle meta = new ByteStreamStateHandle("meta", new byte[]{1, 2, 3});
        ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath> sharedState = new ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath>(1);
        sharedState.add(IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)shared, (String)localPath));
        return new IncrementalRemoteKeyedStateHandle(backendIdentifier, KeyGroupRange.EMPTY_KEY_GROUP_RANGE, 1L, sharedState, Collections.emptyList(), (StreamStateHandle)meta);
    }
}

