/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProvider;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.scheduler.DefaultSchedulerBuilder;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.GloballyTerminalJobStatusListener;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.function.CheckedSupplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSchedulerBatchSchedulingTest {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();
    private static ScheduledExecutorService singleThreadScheduledExecutorService;
    private static ComponentMainThreadExecutor mainThreadExecutor;

    DefaultSchedulerBatchSchedulingTest() {
    }

    @BeforeAll
    private static void setupClass() {
        singleThreadScheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forSingleThreadExecutor(singleThreadScheduledExecutorService);
    }

    @AfterAll
    private static void teardownClass() {
        if (singleThreadScheduledExecutorService != null) {
            singleThreadScheduledExecutorService.shutdownNow();
        }
    }

    @Test
    void testSchedulingOfJobWithFewerSlotsThanParallelism() throws Exception {
        int parallelism = 5;
        Time batchSlotTimeout = Time.milliseconds((long)5L);
        JobGraph jobGraph = this.createBatchJobGraph(5);
        try (SlotPool slotPool = this.createSlotPool(mainThreadExecutor, batchSlotTimeout);){
            ArrayBlockingQueue submittedTasksQueue = new ArrayBlockingQueue(5);
            TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setSubmitTaskConsumer((tdd, ignored) -> {
                submittedTasksQueue.offer(tdd.getExecutionAttemptId());
                return CompletableFuture.completedFuture(Acknowledge.get());
            }).createTestingTaskExecutorGateway();
            PhysicalSlotProviderImpl slotProvider = new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault(), slotPool);
            GloballyTerminalJobStatusListener jobStatusListener = new GloballyTerminalJobStatusListener();
            SchedulerNG scheduler = this.createScheduler(jobGraph, mainThreadExecutor, (PhysicalSlotProvider)slotProvider, batchSlotTimeout, jobStatusListener);
            CompletableFuture.runAsync(() -> ((SchedulerNG)scheduler).startScheduling(), (Executor)mainThreadExecutor).join();
            SlotPoolUtils.offerSlots(slotPool, mainThreadExecutor, Collections.singletonList(ResourceProfile.ANY), (TaskManagerGateway)new RpcTaskManagerGateway((TaskExecutorGateway)testingTaskExecutorGateway, JobMasterId.generate()));
            Thread.sleep(batchSlotTimeout.toMilliseconds());
            CompletableFuture<JobStatus> terminationFuture = jobStatusListener.getTerminationFuture();
            for (int i = 0; i < 5; ++i) {
                CompletableFuture submittedTaskFuture = CompletableFuture.supplyAsync(CheckedSupplier.unchecked(submittedTasksQueue::take));
                CompletableFuture.anyOf(submittedTaskFuture, terminationFuture).join();
                if (submittedTaskFuture.isDone()) {
                    this.finishExecution((ExecutionAttemptID)submittedTaskFuture.get(), scheduler, mainThreadExecutor);
                    continue;
                }
                Assertions.fail((String)String.format("Job reached a globally terminal state %s before all executions were finished.", terminationFuture.get()));
            }
            FlinkAssertions.assertThatFuture(terminationFuture).isCompletedWithValue((Object)JobStatus.FINISHED);
        }
    }

    private void finishExecution(ExecutionAttemptID executionAttemptId, SchedulerNG scheduler, ComponentMainThreadExecutor mainThreadExecutor) {
        CompletableFuture.runAsync(() -> {
            scheduler.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.INITIALIZING));
            scheduler.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.RUNNING));
            scheduler.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.FINISHED));
        }, (Executor)mainThreadExecutor).join();
    }

    private SlotPool createSlotPool(ComponentMainThreadExecutor mainThreadExecutor, Time batchSlotTimeout) throws Exception {
        return new DeclarativeSlotPoolBridgeBuilder().setBatchSlotTimeout(batchSlotTimeout).buildAndStart(mainThreadExecutor);
    }

    private JobGraph createBatchJobGraph(int parallelism) {
        JobVertex jobVertex = new JobVertex("testing task");
        jobVertex.setParallelism(parallelism);
        jobVertex.setInvokableClass(NoOpInvokable.class);
        return JobGraphTestUtils.batchJobGraph(jobVertex);
    }

    private SchedulerNG createScheduler(JobGraph jobGraph, ComponentMainThreadExecutor mainThreadExecutor, PhysicalSlotProvider physicalSlotProvider, Time slotRequestTimeout, JobStatusListener jobStatusListener) throws Exception {
        return new DefaultSchedulerBuilder(jobGraph, mainThreadExecutor, (ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor()).setExecutionSlotAllocatorFactory((ExecutionSlotAllocatorFactory)SchedulerTestingUtils.newSlotSharingExecutionSlotAllocatorFactory(physicalSlotProvider, slotRequestTimeout)).setJobStatusListener(jobStatusListener).build();
    }
}

