/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.JobInfoImpl;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.RecordCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.IteratorWrappingTestSingleInputGate;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.mailbox.SyncMailboxExecutor;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.SharedResources;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.NoOpTaskManagerActions;
import org.apache.flink.runtime.taskmanager.NoOpTaskOperatorEventGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.types.Record;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;

public class MockEnvironment
implements Environment,
AutoCloseable {
    private final JobInfo jobInfo;
    private final TaskInfo taskInfo;
    private final JobType jobType;
    private final ExecutionConfig executionConfig;
    private final MemoryManager memManager;
    private final SharedResources sharedResources;
    private final IOManager ioManager;
    private final TaskStateManager taskStateManager;
    private final GlobalAggregateManager aggregateManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<IndexedInputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobVertexID jobVertexID;
    private final ExecutionAttemptID executionAttemptID;
    private final TaskManagerRuntimeInfo taskManagerRuntimeInfo;
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry taskKvStateRegistry;
    private final KvStateRegistry kvStateRegistry;
    private final int bufferSize;
    private final UserCodeClassLoader userCodeClassLoader;
    private final TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
    private Optional<Class<? extends Throwable>> expectedExternalFailureCause = Optional.empty();
    private Optional<? extends Throwable> actualExternalFailureCause = Optional.empty();
    private final TaskMetricGroup taskMetricGroup;
    private final ExternalResourceInfoProvider externalResourceInfoProvider;
    private MailboxExecutor mainMailboxExecutor;
    private ExecutorService asyncOperationsThreadPool;
    private CheckpointStorageAccess checkpointStorageAccess;
    private final ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory;

    public static MockEnvironmentBuilder builder() {
        return new MockEnvironmentBuilder();
    }

    protected MockEnvironment(JobID jobID, String jobName, JobVertexID jobVertexID, JobType jobType, String taskName, MockInputSplitProvider inputSplitProvider, int bufferSize, Configuration taskConfiguration, ExecutionConfig executionConfig, IOManager ioManager, TaskStateManager taskStateManager, GlobalAggregateManager aggregateManager, int maxParallelism, int parallelism, int subtaskIndex, UserCodeClassLoader userCodeClassLoader, TaskMetricGroup taskMetricGroup, TaskManagerRuntimeInfo taskManagerRuntimeInfo, MemoryManager memManager, ExternalResourceInfoProvider externalResourceInfoProvider, ChannelStateWriteRequestExecutorFactory channelStateExecutorFactory) {
        this.jobInfo = new JobInfoImpl(jobID, jobName);
        this.jobVertexID = jobVertexID;
        this.jobType = jobType;
        this.taskInfo = new TaskInfoImpl(taskName, maxParallelism, subtaskIndex, parallelism, 0);
        this.jobConfiguration = new Configuration();
        this.taskConfiguration = taskConfiguration;
        this.inputs = new LinkedList<IndexedInputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.executionAttemptID = ExecutionGraphTestUtils.createExecutionAttemptId(jobVertexID, subtaskIndex, 0);
        this.memManager = memManager;
        this.sharedResources = new SharedResources();
        this.ioManager = ioManager;
        this.taskManagerRuntimeInfo = taskManagerRuntimeInfo;
        this.executionConfig = executionConfig;
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.accumulatorRegistry = new AccumulatorRegistry(jobID, this.getExecutionId());
        this.kvStateRegistry = new KvStateRegistry();
        this.taskKvStateRegistry = this.kvStateRegistry.createTaskRegistry(jobID, this.getJobVertexId());
        this.userCodeClassLoader = (UserCodeClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.aggregateManager = (GlobalAggregateManager)Preconditions.checkNotNull((Object)aggregateManager);
        this.taskMetricGroup = taskMetricGroup;
        this.externalResourceInfoProvider = (ExternalResourceInfoProvider)Preconditions.checkNotNull((Object)externalResourceInfoProvider);
        this.mainMailboxExecutor = new SyncMailboxExecutor();
        this.asyncOperationsThreadPool = Executors.newDirectExecutorService();
        this.channelStateExecutorFactory = channelStateExecutorFactory;
    }

    public IteratorWrappingTestSingleInputGate<Record> addInput(MutableObjectIterator<Record> inputIterator) {
        try {
            IteratorWrappingTestSingleInputGate<Record> reader = new IteratorWrappingTestSingleInputGate<Record>(this.bufferSize, this.inputs.size(), inputIterator, Record.class);
            this.inputs.add((IndexedInputGate)reader.getInputGate());
            return reader;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error setting up mock readers: " + t.getMessage(), t);
        }
    }

    public void addInputs(List<IndexedInputGate> gates) {
        this.inputs.addAll(gates);
    }

    public void addOutput(List<Record> outputList) {
        try {
            this.outputs.add(new RecordCollectingResultPartitionWriter(outputList));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assertions.fail((String)t.getMessage());
        }
    }

    public void addOutputs(List<ResultPartitionWriter> writers) {
        this.outputs.addAll(writers);
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public SharedResources getSharedResources() {
        return this.sharedResources;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobInfo.getJobId();
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerRuntimeInfo;
    }

    public TaskMetricGroup getMetricGroup() {
        return this.taskMetricGroup;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public KvStateRegistry getKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public UserCodeClassLoader getUserCodeClassLoader() {
        return this.userCodeClassLoader;
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public IndexedInputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public IndexedInputGate[] getAllInputGates() {
        return this.inputs.toArray(new IndexedInputGate[0]);
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public TaskManagerActions getTaskManagerActions() {
        return new NoOpTaskManagerActions();
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexID;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionAttemptID;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public GlobalAggregateManager getGlobalAggregateManager() {
        return this.aggregateManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.taskKvStateRegistry;
    }

    public ExternalResourceInfoProvider getExternalResourceInfoProvider() {
        return this.externalResourceInfoProvider;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
        throw new UnsupportedOperationException();
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        throw new UnsupportedOperationException();
    }

    public void declineCheckpoint(long checkpointId, CheckpointException cause) {
        throw new UnsupportedOperationException(cause);
    }

    public TaskOperatorEventGateway getOperatorCoordinatorEventGateway() {
        return new NoOpTaskOperatorEventGateway();
    }

    public void failExternally(Throwable cause) {
        if (!this.expectedExternalFailureCause.isPresent()) {
            throw new UnsupportedOperationException("MockEnvironment does not support external task failure.");
        }
        Preconditions.checkArgument((boolean)this.expectedExternalFailureCause.get().isInstance(Preconditions.checkNotNull((Object)cause)));
        Preconditions.checkState((!this.actualExternalFailureCause.isPresent() ? 1 : 0) != 0);
        this.actualExternalFailureCause = Optional.of(cause);
    }

    @Override
    public void close() throws Exception {
        if (!this.memManager.isShutdown()) {
            Preconditions.checkState((boolean)this.memManager.verifyEmpty(), (Object)"Memory Manager managed memory was not completely freed.");
        }
        this.memManager.shutdown();
        this.ioManager.close();
    }

    public void setMainMailboxExecutor(MailboxExecutor mainMailboxExecutor) {
        this.mainMailboxExecutor = mainMailboxExecutor;
    }

    public MailboxExecutor getMainMailboxExecutor() {
        return this.mainMailboxExecutor;
    }

    public void setAsyncOperationsThreadPool(ExecutorService executorService) {
        this.asyncOperationsThreadPool = executorService;
    }

    public ExecutorService getAsyncOperationsThreadPool() {
        return this.asyncOperationsThreadPool;
    }

    public void setCheckpointStorageAccess(CheckpointStorageAccess checkpointStorageAccess) {
        this.checkpointStorageAccess = checkpointStorageAccess;
    }

    public CheckpointStorageAccess getCheckpointStorageAccess() {
        return (CheckpointStorageAccess)Preconditions.checkNotNull((Object)this.checkpointStorageAccess);
    }

    public ChannelStateWriteRequestExecutorFactory getChannelStateExecutorFactory() {
        return this.channelStateExecutorFactory;
    }

    public JobInfo getJobInfo() {
        return this.jobInfo;
    }

    public void setExpectedExternalFailureCause(Class<? extends Throwable> expectedThrowableClass) {
        this.expectedExternalFailureCause = Optional.of(expectedThrowableClass);
    }

    public Optional<? extends Throwable> getActualExternalFailureCause() {
        return this.actualExternalFailureCause;
    }
}

