/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.util.NetUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class ConnectionUtilsTest {
    ConnectionUtilsTest() {
    }

    @Test
    void testReturnLocalHostAddressUsingHeuristics() throws Exception {
        InetSocketAddress unreachable = new InetSocketAddress("8.8.8.8", 65535);
        long start = System.nanoTime();
        InetAddress add = ConnectionUtils.findConnectingAddress((InetSocketAddress)unreachable, (long)2000L, (long)400L);
        Assertions.assertThat((long)(System.nanoTime() - start)).isLessThan(30000000000L);
        Assertions.assertThat((Object)add).isNotNull();
        Assertions.assertThat((Object)add).isEqualTo((Object)InetAddress.getLocalHost());
    }

    @Test
    void testFindConnectingAddressWhenGetLocalHostThrows() throws Exception {
        try (MockedStatic mocked = Mockito.mockStatic(InetAddress.class);){
            mocked.when(InetAddress::getLocalHost).thenThrow(new Throwable[]{new UnknownHostException()}).thenCallRealMethod();
        }
        InetAddress loopbackAddress = Inet4Address.getByName("127.0.0.1");
        try (final ServerSocket socket = new ServerSocket(0, 1, loopbackAddress);){
            socket.setSoTimeout(0);
            Thread socketServerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        NetUtils.acceptWithoutTimeout((ServerSocket)socket);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            socketServerThread.start();
            InetSocketAddress socketAddress = new InetSocketAddress(loopbackAddress, socket.getLocalPort());
            InetAddress address = ConnectionUtils.findConnectingAddress((InetSocketAddress)socketAddress, (long)2000L, (long)400L);
            Assertions.assertThat((Object)address).isNotNull();
        }
    }
}

