/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyServiceProducer;

public class TestingNettyServiceProducer
implements NettyServiceProducer {
    private final BiConsumer<TieredStorageSubpartitionId, NettyConnectionWriter> connectionEstablishedConsumer;
    private final Consumer<NettyConnectionId> connectionBrokenConsumer;

    private TestingNettyServiceProducer(BiConsumer<TieredStorageSubpartitionId, NettyConnectionWriter> connectionEstablishedConsumer, Consumer<NettyConnectionId> connectionBrokenConsumer) {
        this.connectionEstablishedConsumer = connectionEstablishedConsumer;
        this.connectionBrokenConsumer = connectionBrokenConsumer;
    }

    public void connectionEstablished(TieredStorageSubpartitionId subpartitionId, NettyConnectionWriter nettyConnectionWriter) {
        this.connectionEstablishedConsumer.accept(subpartitionId, nettyConnectionWriter);
    }

    public void connectionBroken(NettyConnectionId connectionId) {
        this.connectionBrokenConsumer.accept(connectionId);
    }

    public static class Builder {
        private BiConsumer<TieredStorageSubpartitionId, NettyConnectionWriter> connectionEstablishConsumer = (subpartitionId, nettyConnectionWriter) -> {};
        private Consumer<NettyConnectionId> connectionBrokenConsumer = connectionId -> {};

        public Builder setConnectionEstablishConsumer(BiConsumer<TieredStorageSubpartitionId, NettyConnectionWriter> connectionEstablishConsumer) {
            this.connectionEstablishConsumer = connectionEstablishConsumer;
            return this;
        }

        public Builder setConnectionBrokenConsumer(Consumer<NettyConnectionId> connectionBrokenConsumer) {
            this.connectionBrokenConsumer = connectionBrokenConsumer;
            return this;
        }

        public TestingNettyServiceProducer build() {
            return new TestingNettyServiceProducer(this.connectionEstablishConsumer, this.connectionBrokenConsumer);
        }
    }
}

